/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static Date gettoday() {
        return DateUtils.trunctoday(new Date());
    }

    public static Date trunctoday(Date d) {
        return DateUtils.truncate((Date)d, (int)5);
    }

    public static long getDaysBetween(Date startDate, Date endDate) {
        return (DateUtils.trunctoday(startDate).getTime() - DateUtils.trunctoday(endDate).getTime()) / 86400000L + 1L;
    }

    public static long getDayOfWeek(Date date) {
        return DateUtils.toCalendar((Date)date).get(7);
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return calendar.getTime();
    }

    public static String getWeek(Date date) {
        return String.valueOf(DateUtils.getDayOfWeek(date) - 1L);
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static String getTodayStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(DateUtils.gettoday());
    }

    public static String getDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String getDateStr(Date date, String formate) {
        SimpleDateFormat sdf = new SimpleDateFormat(formate);
        return sdf.format(date);
    }

    public static String getDateTimeStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static long strDateTimeLong(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getDateTimeDuration(long endTime, long startTime) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        String time = "";
        long diff = endTime - startTime;
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        String d = day + " day, " + hour + ":" + min + ":" + sec;
        String h = hour + ":" + min + ":" + sec;
        time = day == 0L ? h : d;
        return time;
    }

    public static int compare2Date(Date d1, Date d2) {
        long ld2;
        long ld1 = Long.valueOf(DateUtils.getDateStr(d1, "yyyyMMdd"));
        if (ld1 > (ld2 = Long.valueOf(DateUtils.getDateStr(d2, "yyyyMMdd")).longValue())) {
            return 1;
        }
        if (ld1 == ld2) {
            return 0;
        }
        return -1;
    }

    public static String getNextDay(String today, int nnn) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd").parse(today);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + nnn);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    public static String getNextDay(Date date, int nnn) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + nnn);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    public static String getNowStr() {
        return DateUtils.getDateTimeStr(new Date());
    }

    public static List<String> splitDateToWeek(int week1IsFirstDay, String startDate, String endDate) throws ParseException {
        ArrayList<String> resultlist = new ArrayList<String>();
        ArrayList<String> listWeekOrMonth = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat olddateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat newdateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date sDate = dateFormat.parse(startDate);
        Calendar sCalendar = Calendar.getInstance();
        sCalendar.setFirstDayOfWeek(2);
        sCalendar.setTime(sDate);
        Date eDate = dateFormat.parse(endDate);
        Calendar eCalendar = Calendar.getInstance();
        eCalendar.setFirstDayOfWeek(2);
        eCalendar.setTime(eDate);
        boolean bool = true;
        while (sCalendar.getTime().getTime() < eCalendar.getTime().getTime()) {
            String time;
            int week1 = sCalendar.get(7);
            if (1 == week1IsFirstDay) {
                if (bool || --week1 == 1 || week1 == 0) {
                    time = dateFormat.format(sCalendar.getTime());
                    listWeekOrMonth.add(time);
                    bool = false;
                }
            } else if (bool || week1 == 1 || week1 == 7) {
                time = dateFormat.format(sCalendar.getTime());
                listWeekOrMonth.add(time);
                bool = false;
            }
            sCalendar.add(5, 1);
        }
        Calendar newCalendar = eCalendar;
        listWeekOrMonth.add(olddateFormat.format(newCalendar.getTime()));
        if (listWeekOrMonth.size() % 2 != 0) {
            listWeekOrMonth.add(dateFormat.format(eCalendar.getTime()));
        }
        for (int g = 0; g < listWeekOrMonth.size(); g += 2) {
            String startTime = (String)listWeekOrMonth.get(g);
            String endTime = (String)listWeekOrMonth.get(g + 1);
            String time = startTime + "@" + endTime;
            resultlist.add(time);
        }
        return resultlist;
    }

    public static final List splitDateToMonths(int mode, String startDate, String endDate) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date sDate = dateFormat.parse(startDate);
        Calendar sCalendar = Calendar.getInstance();
        Date eDate = dateFormat.parse(endDate);
        Calendar eCalendar = Calendar.getInstance();
        return null;
    }
}

