/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.OrderFailureLogBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FStorageOperations;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="HgoPayUtils")
public class HgoPayUtils {
    public final String CancelOrder = "CANC";

    public static HgoPayUtils getInstance() {
        if (!SpringBeanFactory.containsBean("HgoPayUtils")) {
            return null;
        }
        return SpringBeanFactory.getBean("HgoPayUtils", HgoPayUtils.class);
    }

    public FStorageOperations getStorageOperations() {
        return SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class);
    }

    private OrderFailureLogBean createOrderFailureLog(ServiceSession session, String business_type, String gh_state, String billno, JSONObject query_params) {
        OrderFailureLogBean log = new OrderFailureLogBean();
        log.setPh_key(UniqueID.getUniqueID());
        log.setEnt_id(session.getEnt_id());
        log.setBusiness_type(business_type);
        log.setGh_state(gh_state);
        log.setOrderno(billno);
        log.setQuery_string(query_params.toJSONString());
        return log;
    }

    private void insertLog(ServiceSession session, OrderFailureLogBean log, String error_cause) {
        try {
            log.setError_cause(error_cause);
            log.setRequest_time(new Date());
            log.setTmdd(new Date().getTime() / 1000L);
            this.getStorageOperations().insert((Object)log);
        }
        catch (Exception e) {
            ServiceLogs.debuglog(session, "insertLog_err", e.getMessage(), 0L);
        }
    }

    public boolean verifyPay(ServiceSession session, String business_type, String billno, String out_trade_no, String transaction_id, String gh_state, JSONObject query_params) {
        block11: {
            String verifyTradeNo = business_type.concat(billno);
            OrderFailureLogBean log = this.createOrderFailureLog(session, business_type, gh_state, billno, query_params);
            if (!verifyTradeNo.equals(out_trade_no)) {
                this.insertLog(session, log, "billno\u4e0eout_trade_no\u4e0d\u5339\u914d");
                return false;
            }
            long starttime = new Date().getTime();
            if (StringUtils.isEmpty((String)gh_state)) {
                gh_state = this.getStateByOutTradeNo(session, out_trade_no);
            }
            if (StringUtils.isEmpty((String)gh_state)) {
                this.insertLog(session, log, "\u65e0\u6cd5\u627e\u5230gh_state");
                return false;
            }
            JSONObject jsonparam = this.buildVerifyParam(business_type, billno, gh_state);
            try {
                ServiceLogs.debuglog(session, "verifyPay_request", jsonparam.toJSONString(), starttime);
                String queryUrl = RestClientUtils.getRestUtils().queryServiceURI("omw.pay.orderquery");
                ServiceResponse response = RestClientUtils.getRestUtils("RestClientUtils_Wechat").sendRequest(session, queryUrl, jsonparam.toJSONString());
                ServiceLogs.debuglog(session, "verifyPay_response", JSONObject.toJSONString((Object)response), starttime);
                JSONObject result = null;
                if (response.getData() instanceof String) {
                    result = JSON.parseObject((String)((String)response.getData()));
                } else if (response.getData() instanceof JSONObject) {
                    result = (JSONObject)response.getData();
                } else {
                    ServiceLogs.debuglog(session, "verifyPay_err", "\u8ba2\u5355\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u683c\u5f0f\u9519\u8bef", starttime);
                    this.insertLog(session, log, "\u8ba2\u5355\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u683c\u5f0f\u9519\u8bef:".concat(JSONObject.toJSONString((Object)response)));
                    return false;
                }
                if (!result.containsKey((Object)"return_code") || !result.containsKey((Object)"trade_state") || !result.getString("return_code").equalsIgnoreCase("SUCCESS") || !result.getString("trade_state").equalsIgnoreCase("SUCCESS")) break block11;
                if (StringUtils.isNotEmpty((String)transaction_id)) {
                    if (result.containsKey((Object)"transaction_id") && result.getString("transaction_id").equals(transaction_id)) {
                        return true;
                    }
                    break block11;
                }
                this.insertLog(session, log, "\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c\u9a8c\u8bc1\u5931\u8d25:".concat(JSONObject.toJSONString((Object)result)));
                return true;
            }
            catch (Exception e) {
                ServiceLogs.debuglog(session, "verifyPay_err", e.getMessage(), starttime);
                this.insertLog(session, log, "\u8ba2\u5355\u9a8c\u8bc1\u5f02\u5e38:".concat(e.getMessage()));
            }
        }
        return false;
    }

    public ServiceResponse queryPay(ServiceSession session, String business_type, String billno, String gh_state) {
        String out_trade_no = business_type.concat(billno);
        long starttime = new Date().getTime();
        if (StringUtils.isEmpty((String)gh_state)) {
            gh_state = this.getStateByOutTradeNo(session, out_trade_no);
        }
        if (StringUtils.isEmpty((String)gh_state)) {
            return ServiceResponse.buildFailure(session, "10000", "\u6ca1\u6709gh_state", new Object[0]);
        }
        JSONObject jsonparam = this.buildVerifyParam(business_type, billno, gh_state);
        try {
            JSONObject result;
            ServiceLogs.debuglog(session, "isOrderPay_request", jsonparam.toJSONString(), starttime);
            String queryUrl = RestClientUtils.getRestUtils().queryServiceURI("omw.pay.orderquery");
            ServiceResponse response = RestClientUtils.getRestUtils("RestClientUtils_Wechat").sendRequest(session, queryUrl, jsonparam.toJSONString());
            ServiceLogs.debuglog(session, "isOrderPay_response", JSONObject.toJSONString((Object)response), starttime);
            if (response.getData() instanceof String) {
                result = JSON.parseObject((String)((String)response.getData()));
            } else if (response.getData() instanceof JSONObject) {
                result = (JSONObject)response.getData();
            } else {
                ServiceLogs.debuglog(session, "isOrderPay_err", "\u8ba2\u5355\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u683c\u5f0f\u9519\u8bef", starttime);
                return ServiceResponse.buildFailure(session, "10000", "\u8ba2\u5355\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u683c\u5f0f\u9519\u8bef", new Object[0]);
            }
            if (result.containsKey((Object)"return_code") && result.containsKey((Object)"trade_state") && result.getString("return_code").equalsIgnoreCase("SUCCESS") && result.getString("trade_state").equalsIgnoreCase("SUCCESS")) {
                result.put("gh_state", (Object)gh_state);
                return ServiceResponse.buildSuccess(result);
            }
        }
        catch (Exception e) {
            ServiceLogs.debuglog(session, "isOrderPay_err", e.getMessage(), starttime);
        }
        return ServiceResponse.buildFailure(session, "10000", "\u6ca1\u6709\u67e5\u8be2\u5230\u652f\u4ed8\u4fe1\u606f", new Object[0]);
    }

    private JSONObject getPayAttachData(ServiceSession session, JSONObject jsonparam) {
        ServiceResponse response;
        long starttime = new Date().getTime();
        JSONObject attachJson = null;
        try {
            response = RestClientUtils.getRestUtils().sendRequest(session, "omw.payattach.search", jsonparam, "notrace");
            ServiceLogs.debuglog(session, "getPayattachData_response", JSONObject.toJSONString((Object)response), starttime);
        }
        catch (Exception e) {
            ServiceLogs.debuglog(session, "getPayattachData_err", e.getMessage(), starttime);
            response = ServiceResponse.buildFailure(session, "50000", e.getMessage(), new Object[0]);
        }
        if (response != null && response.getReturncode().equalsIgnoreCase("0") && response.getData() instanceof JSONObject) {
            JSONArray payAttachs;
            JSONObject data = (JSONObject)response.getData();
            if (data.containsKey((Object)"total_results") && data.getInteger("total_results") != 1) {
                ServiceLogs.debuglog(session, "getPayattachData_err", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38:".concat(JSONObject.toJSONString((Object)response)), starttime);
                return null;
            }
            if (data.containsKey((Object)"pay_attach") && data.get((Object)"pay_attach") instanceof JSONArray && (payAttachs = data.getJSONArray("pay_attach")).get(0) instanceof JSONObject) {
                attachJson = payAttachs.getJSONObject(0);
            }
        }
        return attachJson;
    }

    public String getPayAttachByOutTradeNo(ServiceSession session, String out_trade_no) {
        long starttime = new Date().getTime();
        String attach = null;
        JSONObject jsonparam = new JSONObject();
        jsonparam.put("orderid", (Object)out_trade_no);
        JSONObject payAttachJson = this.getPayAttachData(session, jsonparam);
        if (payAttachJson != null && payAttachJson.containsKey((Object)"paydata")) {
            try {
                JSONObject attachJson = JSONObject.parseObject((String)payAttachJson.getString("paydata"));
                if (attachJson.containsKey((Object)"attach")) {
                    attach = attachJson.getString("attach");
                }
            }
            catch (RuntimeException e) {
                ServiceLogs.debuglog(session, "getPayAttach_err", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38:".concat(JSONObject.toJSONString((Object)payAttachJson)), starttime);
            }
        }
        return attach;
    }

    public String getStateByOutTradeNo(ServiceSession session, String out_trade_no) {
        long starttime = new Date().getTime();
        String gh_state = null;
        JSONObject jsonparam = new JSONObject();
        jsonparam.put("orderid", (Object)out_trade_no);
        JSONObject payAttachJson = this.getPayAttachData(session, jsonparam);
        if (payAttachJson != null && payAttachJson.containsKey((Object)"state")) {
            gh_state = payAttachJson.getString("state");
        }
        return gh_state;
    }

    private JSONObject buildVerifyParam(String business_type, String billno, String gh_state) {
        JSONObject json = new JSONObject();
        json.put("state", (Object)gh_state);
        json.put("out_trade_no", (Object)business_type.concat(billno));
        return json;
    }

    public static interface Smg {
        public static final String ScanShop = "SORD";
    }

    public static interface Community {
        public static final String Pay = "BMAL";
        public static final String Refund = "RMAL";
    }

    public static interface Park {
        public static final String CarPark = "PARK";
        public static final String RefCarPark = "RPAR";
    }

    public static interface Activity {
        public static final String BuyCoupon = "BCOP";
        public static final String RefCoupon = "RCOP";
        public static final String BuyGift = "BGIF";
        public static final String RefGift = "RGIF";
    }

    public static interface Wallet {
        public static final String BuyCard = "PURH";
        public static final String RefBuyCard = "RPUR";
        public static final String Recharge = "CHAG";
        public static final String RefRecharge = "RCHA";
    }
}

