/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.SpringBeanFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.env.Environment;

public class IniReader {
    protected HashMap<String, Map<String, String>> sections = new HashMap();
    private transient String currentSecion;
    private transient Map<String, String> current;
    private boolean ibinit = false;

    public IniReader() {
    }

    public IniReader(String filename) throws IOException {
        this.init(filename);
    }

    public void init(String filename) throws IOException {
        if (filename.startsWith("NACOS:")) {
            Environment env = (Environment)SpringBeanFactory.getContext().getBean(Environment.class);
            String server = "http://" + env.getProperty("nacos.config.server-addr") + "/nacos";
            String nspace = env.getProperty("nacos.config.namespace");
            String group = env.getProperty("nacos.config.group");
            String dataid = filename.substring(6).trim();
            String url = server + "/v1/cs/configs?tenant=" + nspace + "&dataId=" + dataid + "&group=" + group;
            System.out.println(url);
            try {
                this.httpRequest(url, "GET", null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            File input = new File(filename);
            InputStreamReader isr = null;
            try {
                if (!input.exists()) {
                    URL fps = new URL(filename);
                    input = new File(fps.toURI());
                }
                isr = new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8");
            }
            catch (Exception ex) {
                try {
                    InputStream in = IniReader.class.getClassLoader().getResourceAsStream(filename);
                    isr = new InputStreamReader(in);
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            BufferedReader reader = new BufferedReader(isr);
            this.read(reader);
            reader.close();
        }
        this.ibinit = true;
    }

    protected void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    protected void parseLine(String line) {
        if ((line = line.trim()).matches("\\[\\w+\\]")) {
            this.currentSecion = line.replaceFirst("\\[(.*)\\]", "$1");
            this.current = new HashMap<String, String>();
            this.sections.put(this.currentSecion, this.current);
        } else if (line.matches(".*=.*") && this.current != null) {
            int i = line.indexOf(61);
            String name = line.substring(0, i);
            String value = line.substring(i + 1);
            this.current.put(name, value);
        }
    }

    public Map<String, String> getsection(String section) {
        Map<String, String> p = this.sections.get(section);
        if (p == null) {
            return null;
        }
        return p;
    }

    public String getValue(String section, String name) {
        Map<String, String> p = this.sections.get(section);
        if (p == null) {
            return null;
        }
        String value = p.get(name);
        return value;
    }

    public boolean isinit() {
        return this.ibinit;
    }

    protected void httpRequest(String requestUrl, String requestMethod, String outputStr) throws Exception {
        URL url = new URL(requestUrl);
        HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
        httpUrlConn.setDoOutput(true);
        httpUrlConn.setDoInput(true);
        httpUrlConn.setUseCaches(false);
        httpUrlConn.setRequestMethod(requestMethod);
        if ("GET".equalsIgnoreCase(requestMethod)) {
            httpUrlConn.connect();
        } else if (null != outputStr) {
            OutputStream outputStream = httpUrlConn.getOutputStream();
            outputStream.write(outputStr.getBytes("UTF-8"));
            outputStream.close();
        }
        InputStream inputStream = httpUrlConn.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String str = null;
        while ((str = bufferedReader.readLine()) != null) {
            this.parseLine(str);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        inputStream = null;
        httpUrlConn.disconnect();
    }
}

