/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.springframework.util.StringUtils;

public class SendMailUtils {
    public static MimeMessage createMimeMessage(Session session, Map<Object, String> sendMail, List<Map<Object, String>> receiveMails, List<Map<Object, String>> ccMails, List<Map<Object, String>> bccMails, String Subject, String Content, String imagefilepath, List<Object> attachmentfiles) throws Exception {
        Iterator<Map<Object, String>> iterator;
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(sendMail.get("sendEmailAccount"), StringUtils.isEmpty((Object)sendMail.get("sendEmailNick")) ? sendMail.get("sendEmailAccount") : sendMail.get("sendEmailNick"), "UTF-8"));
        int receivesize = receiveMails.size();
        Address[] receivelist = new Address[receivesize];
        int index = 0;
        Iterator<Map<Object, String>> iterator2 = receiveMails.iterator();
        while (iterator2.hasNext()) {
            Map<Object, String> receiveMail;
            receivelist[index] = new InternetAddress(receiveMail.get("receiveEmailAccount"), StringUtils.isEmpty((Object)(receiveMail = iterator2.next()).get("receiveEmailNick")) ? receiveMail.get("receiveEmailAccount") : receiveMail.get("receiveEmailNick"), "UTF-8");
            ++index;
        }
        message.setRecipients(MimeMessage.RecipientType.TO, receivelist);
        if (!StringUtils.isEmpty(ccMails)) {
            index = 0;
            int ccMailsize = ccMails.size();
            Address[] ccMaillist = new Address[ccMailsize];
            iterator = ccMails.iterator();
            while (iterator.hasNext()) {
                Map<Object, String> ccMail;
                ccMaillist[index] = new InternetAddress(ccMail.get("ccEmailAccount"), StringUtils.isEmpty((Object)(ccMail = iterator.next()).get("ccEmailNick")) ? ccMail.get("ccEmailAccount") : ccMail.get("ccEmailNick"), "UTF-8");
                ++index;
            }
            if (ccMailsize != 0) {
                message.addRecipients(MimeMessage.RecipientType.CC, ccMaillist);
            }
        }
        if (!StringUtils.isEmpty(bccMails)) {
            index = 0;
            int bccMailsize = bccMails.size();
            Address[] bccMaillist = new Address[bccMailsize];
            iterator = bccMails.iterator();
            while (iterator.hasNext()) {
                Map<Object, String> bccMail;
                bccMaillist[index] = new InternetAddress(bccMail.get("bccEmailAccount"), StringUtils.isEmpty((Object)(bccMail = iterator.next()).get("bccEmailNick")) ? bccMail.get("bccEmailAccount") : bccMail.get("bccEmailNick"), "UTF-8");
                ++index;
            }
            if (bccMailsize != 0) {
                message.addRecipients(MimeMessage.RecipientType.BCC, bccMaillist);
            }
        }
        message.setSubject(Subject, "UTF-8");
        MimeBodyPart text = new MimeBodyPart();
        MimeMultipart mm_text_image = new MimeMultipart();
        if (!StringUtils.isEmpty((Object)imagefilepath)) {
            MimeBodyPart image = new MimeBodyPart();
            DataHandler dh = new DataHandler((DataSource)new FileDataSource(imagefilepath));
            image.setDataHandler(dh);
            image.setContentID("image_fairy_tail");
            text.setContent((Object)(Content + "<br/><img src='cid:image_fairy_tail'/>"), "text/html;charset=UTF-8");
            mm_text_image.addBodyPart((BodyPart)text);
            mm_text_image.addBodyPart((BodyPart)image);
        } else {
            text.setContent((Object)Content, "text/html;charset=UTF-8");
            mm_text_image.addBodyPart((BodyPart)text);
        }
        mm_text_image.setSubType("related");
        MimeBodyPart text_image = new MimeBodyPart();
        text_image.setContent((Multipart)mm_text_image);
        MimeMultipart mm = new MimeMultipart();
        mm.addBodyPart((BodyPart)text_image);
        if (!StringUtils.isEmpty(attachmentfiles)) {
            for (Object attachmentpath : attachmentfiles) {
                MimeBodyPart attachment = new MimeBodyPart();
                DataHandler dh2 = new DataHandler((DataSource)new FileDataSource(attachmentpath.toString()));
                attachment.setDataHandler(dh2);
                attachment.setFileName(MimeUtility.encodeText((String)dh2.getName()));
                mm.addBodyPart((BodyPart)attachment);
            }
        }
        mm.setSubType("mixed");
        message.setContent((Multipart)mm);
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }

    public static void sendMail(Map<Object, String> sendMail, List<Map<Object, String>> receiveMails, List<Map<Object, String>> ccMails, List<Map<Object, String>> bccMails, String sendEmailSubject, String sendEmailContent, String imagefilepath, List<Object> attachmentfiles) throws Exception {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", sendMail.get("sendEmailSMTPHost"));
        props.setProperty("mail.smtp.auth", "true");
        if (!StringUtils.isEmpty((Object)sendMail.get("sendEmailSMTPPort")) && !"25".equals(sendMail.get("sendEmailSMTPPort"))) {
            String smtpPort = sendMail.get("sendEmailSMTPPort");
            props.setProperty("mail.smtp.port", smtpPort);
            if ("smtp-mail.outlook.com".equals(sendMail.get("sendEmailSMTPHost"))) {
                props.setProperty("mail.smtp.starttls.enable", "true");
                props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
            } else {
                props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.setProperty("mail.smtp.socketFactory.fallback", "false");
                props.setProperty("mail.smtp.socketFactory.port", smtpPort);
            }
        }
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        MimeMessage message = SendMailUtils.createMimeMessage(session, sendMail, receiveMails, ccMails, bccMails, sendEmailSubject, sendEmailContent, imagefilepath, attachmentfiles);
        Transport transport = session.getTransport();
        transport.connect(sendMail.get("sendEmailAccount").toString(), sendMail.get("sendEmailPassword").toString());
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }
}

