/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.util.RestClientUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.util.Assert;

public class Sequencer {
    private String ruleid;
    private long defaultcachenum = 20L;

    public Sequencer(String ruleid, long defaultcachenum) {
        this.ruleid = ruleid;
        this.defaultcachenum = defaultcachenum;
    }

    public long getNext(long ent_id) {
        String sequencerMethod = "mss.sysrule.sequencer.getNext";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", ent_id);
        map.put("ruleid", this.ruleid);
        map.put("cachenum", this.defaultcachenum);
        ServiceResponse response = null;
        try {
            response = RestClientUtils.getRestUtils().sendRequest(new ServiceSession(), sequencerMethod, JSON.toJSONString(map));
            if (!"0".equals(response.getReturncode())) {
                Assert.isTrue((boolean)false, (String)MessageSourceHelper.formatMessage("\u751f\u6210seq\u51fa\u9519[{0}]", response.getData()));
            }
            return Long.valueOf(response.getData().toString());
        }
        catch (Exception e) {
            throw new RuntimeException(MessageSourceHelper.formatMessage("\u751f\u6210seq\u51fa\u9519[{0}]", e.getMessage()));
        }
    }

    public List<Long> getBatch(long ent_id, int batch) {
        String sequencerMethod = "mss.sysrule.sequencer.getBatch";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", ent_id);
        map.put("ruleid", this.ruleid);
        map.put("cachenum", this.defaultcachenum);
        map.put("batch", batch);
        ServiceResponse response = null;
        try {
            response = RestClientUtils.getRestUtils().sendRequest(new ServiceSession(), sequencerMethod, JSON.toJSONString(map));
            if (!"0".equals(response.getReturncode())) {
                Assert.isTrue((boolean)false, (String)MessageSourceHelper.formatMessage("\u751f\u6210seq\u51fa\u9519[{0}]", response.getData()));
            }
            return (List)response.getData();
        }
        catch (Exception e) {
            throw new RuntimeException(MessageSourceHelper.formatMessage("\u751f\u6210seq\u51fa\u9519[{0}]", e.getMessage()));
        }
    }
}

