/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UUID {
    private static String port = "";
    private static String ipAddr0 = "000";
    private static String ipAddr1 = "000";
    private static String ip = "";
    private static long twepoch = 1451577600000L;
    private static int splitStart = 2015;
    private static int splitEnd = 2020;
    private static long workerIdBits = 8L;
    private static long processIdBits = 8L;
    private static long workerIdMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)workerIdBits;
    private static long processIdMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)processIdBits;
    private static long sequenceBits;
    private static long workerIdShift;
    private static long processIdShift;
    private static long timestampLeftShift;
    private static long sequenceMask;
    private static final long MAX_BACKWARD_MILLS = 5L;
    private static Long workerId;
    private static Long processId;
    private static List<Long> BACKWARD;
    private static int BACKWARD_SIZE;
    private static Map<String, WorkerId> allIds;
    private static List<String> ENV_APPID;
    private static List<String> ENV_PREFIX;
    private static List<String> ENV_START;
    private static final int INADDR4SZ = 4;
    public static Logger logger;

    public static UUID getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static String getEnv(String key) {
        String val = System.getProperty(key);
        if (val == null) {
            val = System.getenv(key);
        }
        if (val == null) {
            val = "";
        }
        val = val.trim();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getId(String key) {
        WorkerId workerId = allIds.get(key);
        if (workerId == null) {
            Map<String, WorkerId> map = allIds;
            synchronized (map) {
                workerId = allIds.get(key);
                if (workerId == null) {
                    UUID.initId();
                    workerId = UUID.getInstance().getWorkerId();
                    allIds.put(key, workerId);
                }
            }
        }
        return workerId.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSeq(String key) {
        WorkerId workerId = allIds.get(key);
        if (workerId == null) {
            Map<String, WorkerId> map = allIds;
            synchronized (map) {
                workerId = allIds.get(key);
                if (workerId == null) {
                    UUID.initId();
                    workerId = UUID.getInstance().getWorkerId();
                    allIds.put(key, workerId);
                }
            }
        }
        return workerId.seq();
    }

    private static void initId() {
        String key;
        Object val;
        if (workerId != null) {
            return;
        }
        for (String key2 : ENV_APPID) {
            val = UUID.getEnv(key2);
            if (((String)val).isEmpty()) continue;
            if (((String)val).length() > 3) {
                val = ((String)val).substring(((String)val).length() - 3);
            }
            workerId = Long.valueOf((String)val);
            processId = 0L;
            return;
        }
        String port = UUID.parsePath();
        String prefixId = "";
        val = ENV_PREFIX.iterator();
        while (val.hasNext() && (prefixId = UUID.getEnv(key = (String)val.next())).isEmpty()) {
        }
        String[] addr = UUID.getIpAddr(prefixId);
        if (port == null || "".equals(port)) {
            workerId = Long.valueOf(addr[2]);
            processId = Long.valueOf(addr[1]);
        } else {
            if (port.length() > 2) {
                port = port.substring(port.length() - 2);
            }
            workerId = Long.valueOf(addr[2]);
            processId = Long.valueOf(port);
        }
        logger.warn("workerId:[" + workerId + "], processId:[" + processId + "]");
    }

    private static String parsePath() {
        String path = UUID.getPath();
        String regex = "\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String s = matcher.group();
            if (s.length() <= 3) continue;
            port = matcher.group();
        }
        port = port != null && port.length() > 3 ? port.substring(port.length() - 4) : null;
        logger.warn("port:[" + port + "]");
        return port;
    }

    public static String getPath() {
        String cpath = null;
        ClassLoader cl = UUID.getDefaultClassLoader();
        URL url = cl != null ? cl.getResource("") : ClassLoader.getSystemResource("");
        File sp = UUID.getFile(url);
        File fp = new File(sp.getAbsolutePath());
        while (!fp.exists() || !fp.isDirectory()) {
            fp = fp.getParentFile();
        }
        cpath = fp.getPath();
        cpath = cpath.replace('\\', '/').toLowerCase();
        logger.info("path:[" + cpath + "]");
        return cpath;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = UUID.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static File getFile(URL resourceUrl) {
        try {
            return new File(UUID.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    private static URI toURI(URL url) throws URISyntaxException {
        return new URI(url.toString().replace(" ", "%20"));
    }

    public static String getHostname() {
        try {
            InetAddress netAddress = InetAddress.getLocalHost();
            return netAddress.getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("\u8b66\u544a:getLocalHost\u7cfb\u7edf\u83b7\u53d6hostname\u5f02\u5e38:" + UUID.getTrace(e));
            return null;
        }
    }

    public static String[] getIpAddr(String prefix) {
        String localIp = null;
        try {
            InetAddress lo = InetAddress.getLocalHost();
            if (!lo.isAnyLocalAddress() && !lo.isLoopbackAddress() && lo instanceof Inet4Address) {
                localIp = lo.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.warn("\u8b66\u544a:getLocalHost\u7cfb\u7edf\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38:" + UUID.getTrace(e));
        }
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> ipv4Result = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (en.hasMoreElements()) {
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    ipv4Result.add(address.getHostAddress());
                }
            }
            ipv4Result.add("127.0.0.1");
            ipv4Result.add("0.0.0.0");
            if (prefix != null && !"".equals(prefix)) {
                for (String key : ipv4Result) {
                    if (key.startsWith("127.0") || !UUID.isInternalIp(key) || !key.startsWith(prefix)) continue;
                    ip = key;
                    break;
                }
                for (String key : ipv4Result) {
                    if (key.startsWith("127.0") || !key.startsWith(prefix)) continue;
                    ip = key;
                    break;
                }
            }
            if ("".equals(ip) && localIp != null) {
                for (String key : ipv4Result) {
                    if (key.startsWith("127.0") || !key.equals(localIp)) continue;
                    ip = key;
                    break;
                }
            }
            if ("".equals(ip)) {
                for (String key : ipv4Result) {
                    if (key.startsWith("127.0")) continue;
                    ip = key;
                    break;
                }
            }
            if ("".equals(ip)) {
                ip = "127.0.0.1";
            }
        }
        catch (SocketException e) {
            logger.warn("\u8b66\u544a:\u7cfb\u7edf\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38," + UUID.getTrace(e));
        }
        String[] rtn = null;
        String[] address = null;
        address = ip.split("\\.");
        ipAddr0 = address[3];
        ipAddr1 = address[2];
        rtn = new String[]{ip, String.format("%03d", Integer.parseInt(ipAddr1)), String.format("%03d", Integer.parseInt(ipAddr0))};
        logger.info("ip \u5730\u5740[" + rtn[0] + "], [" + rtn[1] + "], [" + rtn[2] + "]");
        return rtn;
    }

    private static boolean isInternalIp(String ip) {
        byte[] addr = UUID.textToNumericFormatV4(ip);
        return UUID.isInternalIp(addr);
    }

    private static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public static String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public static String parseId(long id) {
        long time = (id >> (int)timestampLeftShift) + twepoch;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        String sd = sdf.format(calendar.getTime());
        long processId = id >> (int)processIdShift & processIdMask;
        long workerId = id >> (int)workerIdShift & workerIdMask;
        long sequence = id & sequenceMask;
        String val = String.format("time=%s,processId=%03d,workerId=%03d,sequence=%03d", sd, processId, workerId, sequence);
        return val;
    }

    public static Logger getLogger() {
        return logger;
    }

    public WorkerId getWorkerId() {
        WorkerId b = new WorkerId();
        return b;
    }

    public static void main(String[] args) throws Exception {
        final class Test1 {
            Test1() {
            }

            public void testDate() {
                long at = System.currentTimeMillis();
                System.out.println(at);
                long tm = ++at;
                System.out.println(tm);
                System.out.println(at);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar calendar = Calendar.getInstance();
                calendar.set(splitStart, 0, 1, 0, 0, 0);
                calendar.set(14, 0);
                long t1 = calendar.getTimeInMillis();
                System.out.println("0xffffffffffL=1099511627775");
                System.out.println(Long.toBinaryString(t1));
                long t2 = t1 + 0xFFFFFFFFFFL;
                calendar.setTime(new Date(t2));
                System.out.println(sdf.format(calendar.getTime()));
                System.out.println("[" + splitStart + "-01-01]t1=" + t1 + ":t2=" + t2);
                System.out.println("t1=" + String.valueOf(t1).length() + ":t2=" + String.valueOf(t2).length() + ":max=" + (t2 - t1));
                calendar.set(2049, 10, 3, 0, 0, 0);
                calendar.set(14, 0);
                t2 = calendar.getTimeInMillis();
                System.out.println(t2 - t1 + "===> 0xffffffffffL=" + 0xFFFFFFFFFFL);
            }
        }
        new Test1().testDate();
    }

    static {
        workerIdShift = sequenceBits = 7L;
        processIdShift = sequenceBits + workerIdBits;
        timestampLeftShift = sequenceBits + workerIdBits + processIdBits;
        sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)sequenceBits;
        BACKWARD = new ArrayList<Long>();
        BACKWARD_SIZE = 0;
        allIds = new HashMap<String, WorkerId>();
        ENV_APPID = new ArrayList<String>();
        ENV_PREFIX = new ArrayList<String>();
        ENV_START = new ArrayList<String>();
        ENV_APPID.add("GLOBAL_APPID");
        ENV_APPID.add("COMMON_APPID");
        ENV_APPID.add("OCMOMP_APPID");
        ENV_START.add("GLOBAL_TIME_SET");
        ENV_START.add("COMMON_TIME_SET");
        ENV_PREFIX.add("GLOBAL_APPID_PREFIX");
        ENV_PREFIX.add("COMMON_APPID_PREFIX");
        ENV_PREFIX.add("OCMOMP_APPID_PREFIX");
        ENV_PREFIX.add("GLOBAL_IP_PREFIX");
        ENV_PREFIX.add("COMMON_IP_PREFIX");
        ENV_PREFIX.add("OCMOMP_IP_PREFIX");
        Calendar calendar = Calendar.getInstance();
        calendar.set(splitStart, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        twepoch = calendar.getTimeInMillis();
        for (int i = splitStart; i < splitEnd; ++i) {
            calendar.set(i, 0, 1, 0, 0, 0);
            calendar.set(14, 0);
            BACKWARD.add(calendar.getTimeInMillis());
        }
        BACKWARD_SIZE = BACKWARD.size();
        logger = new Logger();
    }

    class WorkerId {
        private long sequence = 0L;
        private long lastTimestamp = -1L;
        private int backupStep = 0;

        WorkerId() {
        }

        public synchronized long seq() {
            long curTimestamp = this.timeGen();
            if (curTimestamp < this.lastTimestamp) {
                this.sequence = this.sequence + 1L & sequenceMask;
                if (this.sequence == 0L) {
                    ++this.lastTimestamp;
                }
                curTimestamp = this.lastTimestamp;
            } else if (curTimestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & sequenceMask;
                if (this.sequence == 0L) {
                    this.lastTimestamp = ++curTimestamp;
                }
            } else {
                this.sequence = 0L;
                this.lastTimestamp = curTimestamp;
            }
            return curTimestamp - twepoch << (int)timestampLeftShift | processId << (int)processIdShift | workerId << (int)workerIdShift | this.sequence;
        }

        public synchronized long value() {
            long curTimestamp = this.timeGen();
            boolean isBackup = false;
            if (curTimestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - curTimestamp;
                while (offset > 0L && offset <= 5L) {
                    try {
                        Thread.sleep(offset);
                        curTimestamp = this.timeGen();
                        offset = this.lastTimestamp - curTimestamp;
                        if (offset <= 5L && offset >= 0L) continue;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (offset > 5L) {
                    isBackup = true;
                }
            }
            if (this.lastTimestamp == curTimestamp) {
                this.sequence = this.sequence + 1L & sequenceMask;
                if (this.sequence == 0L) {
                    curTimestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            if (isBackup) {
                this.backupStep %= BACKWARD_SIZE;
                curTimestamp = this.tilMoveMillis(curTimestamp);
            } else {
                this.lastTimestamp = curTimestamp;
            }
            return curTimestamp - twepoch << (int)timestampLeftShift | processId << (int)processIdShift | workerId << (int)workerIdShift | this.sequence;
        }

        protected long tilNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }

        protected long tilMoveMillis(long curTimestamp) {
            Calendar r = Calendar.getInstance();
            r.setTimeInMillis(curTimestamp);
            r.set(r.get(1), 0, 1, 0, 0, 0);
            r.set(14, 0);
            long subMills = curTimestamp - r.getTimeInMillis();
            this.backupStep %= BACKWARD.size();
            curTimestamp = (Long)BACKWARD.get(this.backupStep) + subMills;
            ++this.backupStep;
            return curTimestamp;
        }
    }

    private static class Logger {
        private Logger() {
        }

        public void info(String msg) {
            int level = 1;
            StackTraceElement[] stacks = new Throwable().getStackTrace();
            int line = stacks[level].getLineNumber();
            System.out.println(String.format("%4d-%s", line, msg));
        }

        public void warn(String msg) {
            int level = 1;
            StackTraceElement[] stacks = new Throwable().getStackTrace();
            int line = stacks[level].getLineNumber();
            System.out.println(String.format("%4d-%s", line, msg));
        }
    }

    private static class LazyHolder {
        private static final UUID INSTANCE = new UUID();

        private LazyHolder() {
        }
    }
}

