/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.AsynauditService;
import com.efuture.ocp.common.billservice.AsyncauditlistBean;
import com.efuture.ocp.common.billservice.BillCommonService;
import com.efuture.ocp.common.billservice.ExecAsynaudit;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class AsynauditSrvImpl
extends BasicComponent
implements AsynauditService {
    @Override
    public void run() {
        AsyncauditlistBean billinfo = this.gettask();
        if (null != billinfo) {
            try {
                this.runtask(billinfo);
                this.endrun(billinfo, true, "");
            }
            catch (Exception e) {
                this.endrun(billinfo, false, e.getMessage());
            }
        }
    }

    @Override
    public void uptexeccount(AsyncauditlistBean billinfo, long count) throws Exception {
        String sql = "update asyncauditlist set execcount = " + String.valueOf(billinfo.getExeccount()) + ",execed = execed + " + String.valueOf(count) + " where ph_key =" + String.valueOf(billinfo.getPh_key());
        this.getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate().update("mybatis.sql.update", (Object)sql);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, String> runtask(AsyncauditlistBean billinfo) throws Exception {
        HashMap<String, String> rtn = new HashMap<String, String>();
        if ("BillCommonService".equals(billinfo.getBillobjectclass())) {
            BillCommonService billsrv = SpringBeanFactory.getBean(billinfo.getBillobjectname(), BillCommonService.class);
            JSONObject jsonparam = new JSONObject();
            jsonparam.put("billno", (Object)billinfo.getBillno());
            jsonparam.put("billsgno", (Object)"asyncaudit");
            jsonparam.put("auditor", (Object)billinfo.getAuditor());
            jsonparam.put("auditor_name", (Object)billinfo.getAuditor_name());
            ServiceSession session = new ServiceSession();
            ServiceResponse sr = billsrv.billaudit(session, jsonparam);
            rtn.put("rtn", "0");
            rtn.put("msg", "");
        } else if ("ExecAsynaudit".equals(billinfo.getBillobjectclass())) {
            ExecAsynaudit billsrv = SpringBeanFactory.getBean(billinfo.getBillobjectname(), ExecAsynaudit.class);
            billsrv.doasynaudit(billinfo);
        }
        return rtn;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void ins(AsyncauditlistBean billinfo) {
        this.getStorageOperations().insert((Object)billinfo);
    }

    @Override
    public void ins(long ent_id, String billno, String billmoduleid, String billobjectname, String billobjectclass, String auditor, String auditor_name) {
        AsyncauditlistBean billinfo = new AsyncauditlistBean();
        billinfo.setPh_key(UniqueID.getUniqueID());
        billinfo.setPh_timestamp(new Date());
        billinfo.setBillno(billno);
        billinfo.setBillmoduleid(billmoduleid);
        billinfo.setBillobjectname(billobjectname);
        billinfo.setBillobjectclass(billobjectclass);
        billinfo.setAuditor(auditor);
        billinfo.setAuditor_name(auditor_name);
        billinfo.setExecstatus("N");
        billinfo.setEnt_id(ent_id);
        this.ins(billinfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void endrun(AsyncauditlistBean billinfo, boolean succeed, String errmsg) {
        Update updaterun = new Update();
        billinfo.setExecedate(new Date());
        billinfo.setExecelapsed((billinfo.getExecedate().getTime() - billinfo.getExecsdate().getTime()) / 1000L);
        updaterun.set("execedate", (Object)billinfo.getExecedate());
        updaterun.set("execelapsed", (Object)billinfo.getExecelapsed());
        if (succeed) {
            updaterun.set("execstatus", (Object)"Y");
        } else {
            String msg;
            updaterun.set("execstatus", (Object)"X");
            if (!StringUtils.isEmpty((Object)errmsg)) {
                int end = errmsg.length();
                if (end > 999) {
                    end = 999;
                }
                msg = errmsg.substring(0, end);
            } else {
                msg = "";
            }
            updaterun.set("execerrmsg", (Object)msg);
        }
        Criteria criteriarun = Criteria.where((String)"ph_key").is((Object)billinfo.getPh_key());
        Query queryrun = new Query((CriteriaDefinition)criteriarun);
        this.getStorageOperations().update(queryrun, updaterun, AsyncauditlistBean.class);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public AsyncauditlistBean gettask() {
        FStorageOperations fs = this.getStorageOperations();
        Update update = new Update();
        update.set("execstatus", (Object)"N");
        Criteria criteria = Criteria.where((String)"execstatus").is((Object)"N");
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        int i = fs.update(query, update, AsyncauditlistBean.class);
        if (i == 0) {
            return null;
        }
        criteria = Criteria.where((String)"execstatus").is((Object)"N");
        Query querybillinfo = new Query((CriteriaDefinition)criteria);
        querybillinfo.limit(1);
        AsyncauditlistBean billinfo = (AsyncauditlistBean)fs.selectOne(querybillinfo, AsyncauditlistBean.class);
        billinfo.setExecsdate(new Date());
        billinfo.setStatus("M");
        Update updaterun = new Update();
        updaterun.set("execstatus", (Object)billinfo.getStatus());
        updaterun.set("execsdate", (Object)billinfo.getExecsdate());
        Criteria criteriarun = Criteria.where((String)"ph_key").is((Object)billinfo.getPh_key());
        Query queryrun = new Query((CriteriaDefinition)criteriarun);
        fs.update(queryrun, updaterun, AsyncauditlistBean.class);
        return billinfo;
    }
}

