/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.ReportService;
import com.efuture.ocp.common.billservice.ReportServiceImpl;
import com.efuture.ocp.common.billservice.VirtualFieldServiceImpl;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.StringUtils;

public class VirtualFieldReportServiceImpl
extends ReportServiceImpl
implements ReportService {
    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.query(session, jsonparam, "report");
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam, String datakey) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"queryid"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "queryid");
        }
        if (VirtualFieldServiceImpl.getInstance() != null) {
            VirtualFieldServiceImpl.getInstance().checkExistVirtualField(session, jsonparam);
        }
        int pageno = -1;
        int pagesize = 40;
        if (jsonparam.containsKey((Object)"page_no") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"page_no"))) {
            pageno = jsonparam.getInteger("page_no");
            if (pageno <= 0) {
                pageno = 1;
            }
            jsonparam.remove((Object)"page_no");
        }
        if (jsonparam.containsKey((Object)"page_size") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"page_size"))) {
            pagesize = jsonparam.getInteger("page_size");
            if (pagesize <= 0) {
                pagesize = 40;
            }
            if (pagesize > 10000) {
                pagesize = 10000;
            }
            jsonparam.remove((Object)"page_size");
            if (pageno <= 0) {
                pageno = 1;
            }
        }
        RowBounds rowBounds = null;
        if (pageno >= 1) {
            rowBounds = new RowBounds((pageno - 1) * pagesize, pagesize);
        }
        HashMapCase map = new HashMapCase();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        StringBuffer total = new StringBuffer();
        JSONObject json = new JSONObject();
        json.put(datakey, this.doQuery(jsonparam.getString("queryid"), map, rowBounds, total));
        if (total.toString() != "") {
            json.put("total_results", (Object)total.toString());
        } else {
            json.put("total_results", (Object)"0");
        }
        this.getReportTot(session, json, jsonparam, total);
        return ServiceResponse.buildSuccess(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total) {
        FMybatisTemplate storage = null;
        try {
            List<Map<String, Object>> list;
            storage = this.getStorageOperations(FMybatisTemplate.class);
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            if (rowBounds == null) {
                list = db.selectList(queryid, param);
            } else {
                list = db.selectList(queryid, param, rowBounds);
                if (total != null) {
                    total.append(((Page)list).getTotal());
                }
            }
            if (VirtualFieldServiceImpl.getInstance() != null) {
                list = VirtualFieldServiceImpl.getInstance().handleVirtualField(list);
            }
            List<Map<String, Object>> list2 = list;
            return list2;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    @Override
    public String sumcol_sql(String cols) throws Exception {
        Object sumcols = "";
        for (String col : cols.split(",")) {
            sumcols = (String)sumcols + "sum(" + col + ") " + col + ",";
        }
        return ((String)sumcols).substring(0, ((String)sumcols).length() - 1);
    }

    @Override
    protected void getReportTot(ServiceSession session, JSONObject json, JSONObject jsonparam, StringBuffer total) {
        try {
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"tot_cols")) && !StringUtils.isEmpty((Object)jsonparam.get((Object)"tot_queryid"))) {
                String tot_cols = jsonparam.getString("tot_cols");
                jsonparam.put("tot_cols", (Object)this.sumcol_sql(tot_cols));
                HashMapCase map = new HashMapCase();
                map.put("ent_id", session.getEnt_id());
                for (String key : jsonparam.keySet()) {
                    map.put(key, jsonparam.get((Object)key));
                }
                List<Map<String, Object>> tot_row = this.doQuery(jsonparam.getString("tot_queryid"), map, new RowBounds(0, 100), total);
                if (tot_row.size() > 0) {
                    Map<String, Object> row = tot_row.get(0);
                    for (String key : tot_cols.split(",")) {
                        json.put(key, row.get(key));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (VirtualFieldServiceImpl.getInstance() != null) {
            VirtualFieldServiceImpl.getInstance().checkExistVirtualField(session, jsonparam);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        List<Map<String, Object>> list = this.doQuery(jsonparam.getString("queryid"), map, null, null);
        return this.createExportXLS(list, fldlst, disps, fmts);
    }
}

