/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.alibaba.fastjson.JSON;
import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class CacheUtilsRedisCluster
extends CacheUtilsRediscached
implements Serializable {
    private JedisCluster jedispool;
    private JedisPoolConfig poolConfig;
    private LinkedHashSet<HostAndPort> node_set;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRedisCluster.class);

    public CacheUtilsRedisCluster() {
        this(null);
    }

    public CacheUtilsRedisCluster(String config) {
        this(config, -1);
    }

    public CacheUtilsRedisCluster(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    @Override
    public Object getCacheType() {
        return "cluster";
    }

    private JedisCluster getJedis() {
        try {
            if (this.jedispool == null) {
                try {
                    this.jedispool = this.CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            this.clusterIsAvailable(this.jedispool);
            return this.jedispool;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void returnJedis(JedisCluster jedis) {
    }

    @Override
    public String putDataByElapsed(String key, Object object, int timeout, List<String> elapsed) {
        return this.putData(key, object, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putData(String key, Object object, int timeout) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            if (timeout < 0) {
                int n = timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            if (timeout > 0) {
                jedis.setex(this.getKey(key).getBytes(), timeout, SerializeUtil.serialize(object));
            } else {
                jedis.set(this.getKey(key).getBytes(), SerializeUtil.serialize(object));
            }
            String string = key;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Object getDataByElapsed(String key, List<String> elapsed) {
        return this.getData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        Object result = null;
        try {
            byte[] obj = jedis.get(this.getKey(key).getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        try {
            jedis.del(this.getKey(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    @Override
    public int deleteBatch(String key) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        Long start = System.currentTimeMillis();
        try {
            while (true) {
                String script = "if (redis.call('exists', KEYS[1]) == 0) then    redis.call('hset', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then    redis.call('hincrby', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; return redis.call('pttl', KEYS[1]);";
                Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
                if ("0".equals(result.toString())) {
                    boolean bl = true;
                    return bl;
                }
                long l = System.currentTimeMillis() - start;
                if (l >= (long)waitTime) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int releaseLock(String lockKey, int timeout, String lockId) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return -1;
        }
        try {
            String script = "if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then    return 1; end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter > 0) then \tredis.call('pexpire', KEYS[1], ARGV[1]); \treturn 0; else \tredis.call('del', KEYS[1]); \treturn 1; end;return 1;";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
            int n = Integer.parseInt(result.toString());
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clusterIsAvailable(JedisCluster pool) {
        String flag = EnvironmentParaUtils.getEnvPra("efuture.cache.redisPing", String.class, "N");
        if ("N".equalsIgnoreCase(flag)) {
            return;
        }
        long tmkey = System.currentTimeMillis();
        ArrayList<String> errList = new ArrayList<String>();
        Map map = pool.getClusterNodes();
        for (HostAndPort hap : this.node_set) {
            String ip = hap.getHost() + ":" + hap.getPort();
            String key = null;
            for (String k : map.keySet()) {
                if (!k.equalsIgnoreCase(ip)) continue;
                key = k;
                break;
            }
            if (StringUtils.isEmpty(key)) continue;
            JedisPool jdp = (JedisPool)map.get(key);
            Jedis jedis = null;
            String result = null;
            try {
                jedis = jdp.getResource();
                result = jedis.ping();
                if ("PONG".equalsIgnoreCase(result)) {
                    result = null;
                    continue;
                }
                result = "FAIL";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result = ex.getMessage();
            }
            finally {
                if (jedis != null) {
                    jdp.returnResource(jedis);
                }
                if (StringUtils.isEmpty((Object)result)) continue;
                errList.add(key);
                this.logger.info((Object)("[" + tmkey + "] Redis Cluster " + key + " Ping Elapsed " + (System.currentTimeMillis() - tmkey) + " ms, fail: " + result));
            }
        }
        if (errList.size() > 0) {
            JedisCluster oripool = pool;
            CacheUtilsRedisCluster cacheUtilsRedisCluster = this;
            synchronized (cacheUtilsRedisCluster) {
                if (this.jedispool == oripool) {
                    this.node_set = new LinkedHashSet();
                    for (String key : map.keySet()) {
                        int l_port;
                        String l_host;
                        if (errList.contains(key) || !this.checkJedisConnect(l_host = key.split(":")[0].trim(), l_port = Integer.valueOf(key.split(":")[1]).intValue())) continue;
                        this.node_set.add(new HostAndPort(l_host, l_port));
                    }
                    try {
                        this.jedispool.close();
                        this.jedispool = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.jedispool = new JedisCluster(this.node_set, this.config.getRedisTimeout(), EnvironmentParaUtils.getEnvPra("efuture.cache.redisSoTimeout", Integer.class, this.config.getRedisTimeout()).intValue(), this.getConfig().getRedisMaxAttempts(), this.config.getRedisPassword(), (GenericObjectPoolConfig)this.poolConfig);
                    this.logger.info((Object)("[" + tmkey + "] Redis Cluster Refrush: " + JSON.toJSONString((Object)this.node_set.toArray())));
                }
            }
        }
        if ("L".equalsIgnoreCase(flag)) {
            this.logger.info((Object)("[" + tmkey + "] Redis Cluster Ping Elapsed: " + (System.currentTimeMillis() - tmkey) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkJedisConnect(String l_host, int l_port) {
        try (Connection connection = new Connection(l_host, l_port);){
            connection.connect();
        }
        return true;
    }

    private synchronized JedisCluster CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            String[] str_nodes;
            this.logger.info((Object)"Redis client is creating with configuration.");
            this.poolConfig = new JedisPoolConfig();
            this.poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            this.poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            this.poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            this.poolConfig.setMinIdle(this.config.getRedisMinIdle());
            this.poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            this.node_set = new LinkedHashSet();
            for (String str : str_nodes = this.config.getRedisNodes().split(",")) {
                int l_port;
                String l_host = str.split(":")[0].trim();
                if (!this.checkJedisConnect(l_host, l_port = Integer.valueOf(str.split(":")[1]).intValue())) continue;
                this.node_set.add(new HostAndPort(l_host, l_port));
            }
            this.logger.info((Object)("Redis Cluster Create: " + JSON.toJSONString((Object)this.node_set.toArray())));
            this.jedispool = new JedisCluster(this.node_set, this.config.getRedisTimeout(), EnvironmentParaUtils.getEnvPra("efuture.cache.redisSoTimeout", Integer.class, this.config.getRedisTimeout()).intValue(), this.getConfig().getRedisMaxAttempts(), this.config.getRedisPassword(), (GenericObjectPoolConfig)this.poolConfig);
        } else {
            Object ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini";
                ini0 = p + "/conf/redisCluster.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File((String)ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redisCluster.ini path:" + (String)ini));
            if (input.exists()) {
                String[] str_nodes;
                String sdatabase;
                String password_prop;
                String password;
                String smaxWait;
                String sport;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                String sServer;
                FileInputStream is = new FileInputStream(input);
                Properties p = new Properties();
                p.load(is);
                ((InputStream)is).close();
                String sNodes = Utils.getEnvValue(p.getProperty("redis.nodes"));
                if (sNodes != null) {
                    nodes = sNodes.trim();
                }
                if ((sServer = Utils.getEnvValue(p.getProperty("redis.host"))) != null) {
                    host = sServer.trim();
                }
                if ((smaxActive = p.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((sport = Utils.getEnvValue(p.getProperty("redis.port"))) != null) {
                    port = Integer.parseInt(sport);
                }
                if ((smaxWait = p.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                if ((sdatabase = Utils.getEnvValue(p.getProperty("redis.database"))) != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("rediscached server:" + sNodes));
                this.poolConfig = new JedisPoolConfig();
                this.poolConfig.setTestOnBorrow(true);
                this.poolConfig.setMaxTotal(maxActive);
                this.poolConfig.setMaxIdle(maxIdle);
                this.poolConfig.setMinIdle(minIdle);
                this.poolConfig.setMaxWaitMillis((long)maxWait);
                this.node_set = new LinkedHashSet();
                for (String str : str_nodes = nodes.split(",")) {
                    int l_port;
                    String l_host = str.split(":")[0].trim();
                    if (!this.checkJedisConnect(l_host, l_port = Integer.valueOf(str.split(":")[1]).intValue())) continue;
                    this.node_set.add(new HostAndPort(l_host, l_port));
                }
                this.jedispool = new JedisCluster(this.node_set, timeout, 0, 0, null, (GenericObjectPoolConfig)this.poolConfig);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                this.poolConfig = new JedisPoolConfig();
                this.poolConfig.setTestOnBorrow(true);
                this.poolConfig.setMaxTotal(maxActive);
                this.poolConfig.setMaxIdle(maxIdle);
                this.poolConfig.setMinIdle(minIdle);
                this.poolConfig.setMaxWaitMillis((long)maxWait);
                HostAndPort node = new HostAndPort(host, port);
                this.jedispool = new JedisCluster(node, (GenericObjectPoolConfig)this.poolConfig);
                System.out.println("rediscached server-\u5730\u5740:localhost:" + port);
            }
        }
        return this.jedispool;
    }
}

