/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.calendar.pojo;

import com.efuture.ocp.common.calendar.pojo.CalendaristDate;
import com.efuture.ocp.common.calendar.utils.CalendaristUtils;

public class CycleDate
extends CalendaristDate {
    private String eraYear;
    private String eraMonth;
    private String eraDay;
    private String eraHour;
    private String zodiac;

    public CycleDate() {
    }

    public CycleDate(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0);
    }

    public CycleDate(int year, int month, int day, int hour, int minute, int second, int millis) {
        super(year, month, day, hour, minute, second, millis);
        this.eraYear = CalendaristUtils.ganZhi(year);
        this.eraMonth = CalendaristUtils.ganZhi(month);
        this.eraDay = CalendaristUtils.ganZhi(day);
        this.eraHour = CalendaristUtils.hourGanZhi(day, hour);
        this.zodiac = CalendaristUtils.getZodiac(year + 1864);
    }

    public String getEraDate() {
        return String.format("%s\u5e74%s\u6708%s\u65e5", this.eraYear, this.eraMonth, this.eraDay);
    }

    public String getEraYear() {
        return this.eraYear;
    }

    public void setEraYear(String eraYear) {
        this.eraYear = eraYear;
    }

    public String getEraMonth() {
        return this.eraMonth;
    }

    public void setEraMonth(String eraMonth) {
        this.eraMonth = eraMonth;
    }

    public String getEraDay() {
        return this.eraDay;
    }

    public void setEraDay(String eraDay) {
        this.eraDay = eraDay;
    }

    public String getEraHour() {
        return this.eraHour;
    }

    public void setEraHour(String eraHour) {
        this.eraHour = eraHour;
    }

    public String getZodiac() {
        return this.zodiac;
    }

    public void setZodiac(String zodiac) {
        this.zodiac = zodiac;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CycleDate{");
        sb.append("year=").append(this.year);
        sb.append(", month=").append(this.month);
        sb.append(", day=").append(this.day);
        sb.append(", hour=").append(this.hour);
        sb.append(", minute=").append(this.minute);
        sb.append(", second=").append(this.second);
        sb.append(", millis=").append(this.millis);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", eraYear=").append(this.eraYear);
        sb.append(", eraMonth=").append(this.eraMonth);
        sb.append(", eraDay=").append(this.eraDay);
        sb.append(", eraHour=").append(this.eraHour);
        sb.append(", zodiac=").append(this.zodiac);
        sb.append('}');
        return sb.toString();
    }
}

