/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FStorageOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ExampleComponent
extends BasicComponent {
    public ServiceResponse serviceTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.doServiceTemplate(jsonparam);
            JSONObject respdata = new JSONObject();
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public Object doServiceTemplate(Object param) throws Exception {
        FStorageOperations storage = null;
        try {
            AbstractEntityBean.validateBean(param, new String[0]);
            storage = this.getStorageOperations();
            throw new ServiceException("10000", "error", new Object[0]);
        }
        catch (Throwable throwable) {
            if (storage != null) {
                storage.destroy();
            }
            throw throwable;
        }
    }

    public Object exampleService(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(ServiceSession,JSONObject)\n");
            sb.append("\nsession:\n");
            sb.append(JSON.toJSONString((Object)session) + "\n");
            sb.append("\njsonparam:\n");
            sb.append(jsonparam.toJSONString() + "\n");
            if (jsonparam.containsKey((Object)"locale") && jsonparam.containsKey((Object)"code")) {
                sb.append("\nmsg:\n");
                sb.append(MessageSourceHelper.getDefault().getMessage(jsonparam.getString("code"), null, null, new Locale(jsonparam.getString("locale"))) + "\n");
            }
            return ServiceResponse.buildSuccess(sb.toString());
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return Utils.getLastExceptionMessage(ex);
        }
    }

    public Object exampleService(ServiceSession session, String param) throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(ServiceSession,String)\n");
            sb.append("\nsession:\n");
            sb.append(JSON.toJSONString((Object)session) + "\n");
            sb.append("\nparam:\n");
            sb.append(param + "\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Object exampleService(String param) throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(String)\n");
            sb.append("\nparam:\n");
            sb.append(param + "\n");
            sb.append("\nmsg:\n");
            sb.append(MessageSourceHelper.getDefault().getMessage(param, null, null, null) + "\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Object exampleService() throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(void)\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Object exampleImport(ServiceSession session, String param, List<FileImportObject> list) throws Exception {
        System.out.println("param: " + param);
        for (FileImportObject fio : list) {
            System.out.println("filename: " + fio.getFilename());
            byte[] b = new byte[100];
            fio.getStream().read(b, 0, 100);
            System.out.println("fileline: " + new String(b));
        }
        return list.size();
    }

    public String exampleExport(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        List<Map<String, Object>> list = null;
        return this.createExportXLS(list, fldlst, disps, fmts);
    }
}

