/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.datarange;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BaseService;
import com.efuture.ocp.common.datarange.DataRangeApi;
import com.efuture.ocp.common.datarange.DataRangeService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.OcpApplicationContext;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.user.DataRange;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="com.efuture.ocm.system.datarange")
public class DataRangeApiImpl
extends BaseService
implements DataRangeApi {
    @Autowired
    DataRangeService drs;

    @Override
    public ServiceResponse create(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        long entId = session.getEnt_id();
        String postid = jsonparam.getString("datarange_id");
        if (StringUtils.isEmpty((Object)postid)) {
            return ServiceResponse.buildFailure(session, "30000", "postid\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        JSONArray range = jsonparam.getJSONArray("mkt_range");
        if (range != null && range.size() > 0) {
            this.drs.createDataRange(entId, postid, "mktid", (List<Object>)range);
        }
        if ((range = jsonparam.getJSONArray("cat_range")) != null && range.size() > 0) {
            this.drs.createDataRange(entId, postid, "catid", (List<Object>)range);
        }
        if ((range = jsonparam.getJSONArray("mm_range")) != null && range.size() > 0) {
            this.drs.createDataRange(entId, postid, "mainid", (List<Object>)range);
        }
        FMybatisTemplate fso = OcpApplicationContext.getInstance().getBean("GlobalStorageOperation", FMybatisTemplate.class);
        this.drs.refreshDataRange(fso, entId, postid, null);
        return ServiceResponse.buildSuccess("ok");
    }

    @Override
    public ServiceResponse refresh(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        long entId = session.getEnt_id();
        String postid = jsonparam.getString("postid");
        if (StringUtils.isEmpty((Object)postid)) {
            return ServiceResponse.buildFailure(session, "30000", "postid\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        FMybatisTemplate fso = OcpApplicationContext.getInstance().getBean("GlobalStorageOperation", FMybatisTemplate.class);
        this.drs.refreshDataRange(fso, entId, postid);
        return ServiceResponse.buildSuccess("OK");
    }

    @Override
    public ServiceResponse refreshall(ServiceSession session, JSONObject para) throws Exception {
        boolean isCreate = "true".equalsIgnoreCase(DataUtils.getJsonData(para, "create", false, "false"));
        JSONObject req = new JSONObject();
        req.put("page_size", (Object)999);
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest((Object)session, "efuture.dataRangPermission.search", (Object)req.toJSONString(), "portal");
        if ("0".equalsIgnoreCase(resp.getReturncode())) {
            JSONArray dataRangPermission = ((JSONObject)resp.getData()).getJSONArray("dataRangPermission");
            if (dataRangPermission == null || dataRangPermission.size() <= 0) {
                return ServiceResponse.buildSuccess(null);
            }
            this.drs.clearAutoCache();
            for (int i = 0; i < dataRangPermission.size(); ++i) {
                long entId = DataUtils.getJsonData(dataRangPermission.getJSONObject(i), "entId", true, 0L);
                String postId = DataUtils.getJsonData(dataRangPermission.getJSONObject(i), "drpid", true, "");
                if (isCreate) {
                    this.doCreateFromRemote(session, postId);
                }
                FMybatisTemplate fso = OcpApplicationContext.getInstance().getBean("GlobalStorageOperation", FMybatisTemplate.class);
                this.drs.refreshDataRange(fso, entId, postId);
            }
            return ServiceResponse.buildSuccess("OK");
        }
        return resp;
    }

    @Override
    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.getLogger().info((Object)"session:".concat(JSONObject.toJSONString((Object)session)));
        FMybatisTemplate fso = OcpApplicationContext.getInstance().getBean("GlobalStorageOperation", FMybatisTemplate.class);
        List<DataRange> rtn = this.drs.RefreshCached(session.getEnt_id(), session.getPostid(), fso);
        if (jsonparam.containsKey((Object)"tablename")) {
            String tableName = DataUtils.getJsonData(jsonparam, "tablename", true, "");
            for (DataRange dr : rtn) {
                if (dr.getTablename().equalsIgnoreCase(tableName)) continue;
                rtn.remove(dr);
            }
        }
        return ServiceResponse.buildSuccess(rtn);
    }

    @Override
    public ServiceResponse createall(ServiceSession session, JSONObject jsonparam) throws Exception {
        String param = "{}";
        if (jsonparam != null && jsonparam.containsKey((Object)"rangeid")) {
            param = DataUtils.newJSONObject("drpid", DataUtils.getJsonData(jsonparam, "rangeid", false, "")).toJSONString();
        }
        JSONObject req = new JSONObject();
        req.put("page_size", (Object)999);
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest((Object)session, "efuture.dataRangPermission.search", (Object)req.toJSONString(), "portal");
        if ("0".equalsIgnoreCase(resp.getReturncode())) {
            JSONArray dataRangPermission = ((JSONObject)resp.getData()).getJSONArray("dataRangPermission");
            if (dataRangPermission == null || dataRangPermission.size() <= 0) {
                return ServiceResponse.buildSuccess(null);
            }
            for (int i = 0; i < dataRangPermission.size(); ++i) {
                long entId = DataUtils.getJsonData(dataRangPermission.getJSONObject(i), "entId", true, 0L);
                String postId = DataUtils.getJsonData(dataRangPermission.getJSONObject(i), "drpid", true, "");
                this.doCreateFromRemote(session, postId);
            }
            return ServiceResponse.buildSuccess("OK");
        }
        return resp;
    }

    private String doTraversal(JSONArray array, String dataid, String srcCol, String dstCol) throws Exception {
        if (array != null && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                String result;
                if (dataid.equalsIgnoreCase(DataUtils.getJsonData(array.getJSONObject(i), srcCol, false, ""))) {
                    return DataUtils.getJsonData(array.getJSONObject(i), dstCol, false, "");
                }
                if (!array.getJSONObject(i).containsKey((Object)"children") || StringUtils.isEmpty((Object)(result = this.doTraversal(array.getJSONObject(i).getJSONArray("children"), dataid, srcCol, dstCol)))) continue;
                return result;
            }
        }
        return null;
    }

    private String doRenderDataCode(ServiceSession session, String dataid) throws Exception {
        JSONObject tree = this.drs.getDataRangeTree(session);
        if (tree != null && tree.containsKey((Object)"shop")) {
            JSONArray shops = tree.getJSONArray("shop");
            return this.doTraversal(shops, dataid, "shopId", "shopCode");
        }
        return null;
    }

    private void doCreateFromRemote(ServiceSession session, String postid) throws Exception {
        String METHOD_SELE = "efuture.dataRangPermission.select";
        if (StringUtils.isEmpty((Object)RestClientUtils.getRestUtils().queryServiceURI("efuture.dataRangPermission.select"))) {
            return;
        }
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest((Object)session, "efuture.dataRangPermission.select", (Object)DataUtils.newJSONObject("drpid", postid).toJSONString(), "portal");
        if ("0".equalsIgnoreCase(resp.getReturncode())) {
            JSONArray json = (JSONArray)resp.getData();
            JSONArray mkt_range = new JSONArray();
            if (json != null && json.size() > 0) {
                for (int i = 0; i < json.size(); ++i) {
                    String dataid = json.getString(i);
                    String datacode = this.doRenderDataCode(session, dataid);
                    if (StringUtils.isEmpty((Object)datacode)) continue;
                    JSONObject row = new JSONObject();
                    row.put("dataid", (Object)dataid);
                    row.put("datacode", (Object)datacode);
                    mkt_range.add((Object)row);
                }
            }
            JSONObject createPara = DataUtils.newJSONObject("datarange_id", postid);
            createPara.put("mkt_range", (Object)mkt_range);
            this.create(session, createPara);
        }
    }
}

