/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.dict;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.efuture.ocp.common.dict.DictService;
import com.efuture.ocp.common.dict.MdmDictServiceImpl;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DictUtils {
    public static Map<String, String> dictKeyMap = new HashMap<String, String>();
    static MdmDictServiceImpl defaultSrv;
    private static Map<String, BeanDesc> fieldCache;

    private static void initDefaultSrv() {
        if (defaultSrv == null) {
            defaultSrv = new MdmDictServiceImpl();
        }
    }

    public static DictService getSrv(long entId) {
        String srvName = PropertiesCommon.CONFIG.MDM_DICT_SRV.getVal(entId);
        if ("default".equalsIgnoreCase(srvName)) {
            if (defaultSrv == null) {
                DictUtils.initDefaultSrv();
            }
            return defaultSrv;
        }
        return SpringBeanFactory.getBean(srvName, DictService.class);
    }

    public static String getDictName(long entId, String dictType, String jygs, String dictCode) {
        if (StrUtil.isBlank((CharSequence)dictCode)) {
            return "";
        }
        DictService dictservice = DictUtils.getSrv(entId);
        return dictservice.getDictName(entId, dictType, jygs, dictCode);
    }

    public static Map<String, Object> getLevelCodeName(long entId, String jygs, String inDictCode, String inDictType) {
        if (StrUtil.isBlank((CharSequence)inDictCode)) {
            return MapUtil.empty();
        }
        if (!PropertiesCommon.CONFIG.MDM_HAS_LEVEL.getVal(entId).contains(inDictType.toLowerCase())) {
            return MapUtil.empty();
        }
        DictService dictservice = DictUtils.getSrv(entId);
        return dictservice.getLevelCodeName(entId, jygs, inDictCode, inDictType);
    }

    private static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc = fieldCache.get(clazz.getName());
        if (beanDesc == null) {
            beanDesc = new BeanDesc(clazz);
            fieldCache.put(clazz.getName(), beanDesc);
        }
        return beanDesc;
    }

    public static void setLevelCodeName(long entId, String jygs, String inDictType, String inDictCode, Object bean) {
        Map<String, Object> dict = DictUtils.getLevelCodeName(entId, jygs, inDictCode, inDictType);
        if (dict.isEmpty()) {
            return;
        }
        BeanDesc beanDesc = DictUtils.getBeanDesc(bean.getClass());
        if (beanDesc == null) {
            ServiceLogs.debuglog("setLevelCodeName", "{0} \u83b7\u53d6\u7c7b\u4fe1\u606f\u5931\u8d25", 0L, bean.getClass().getName());
            return;
        }
        for (String key : dict.keySet()) {
            try {
                Field f;
                String field = key.trim().toLowerCase();
                if (!field.startsWith(inDictType.toLowerCase()) || (f = beanDesc.getField(field)) == null) continue;
                f.setAccessible(true);
                f.set(bean, dict.get(key));
            }
            catch (Exception e) {
                ServiceLogs.errLog("setLevelMap.error", e, "type[{0}],code[{1}]", inDictType, inDictCode);
            }
        }
    }

    static {
        fieldCache = new ConcurrentHashMap<String, BeanDesc>();
    }
}

