/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.dict;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.efuture.ocp.common.dict.MdmServiceV2;
import com.efuture.ocp.common.dict.MultilevelMdmRepo;
import com.efuture.ocp.common.dict.MultilevelTableBean;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="mdmServiceDBImplV2")
public class MdmServiceDBImplV2
implements MdmServiceV2 {
    @Override
    public Map<String, Object> getMdmRowData(long entId, String dictType, String jygs, String dictCode) {
        MultilevelTableBean bean = MultilevelMdmRepo.getInstance().get(entId, dictType, jygs, dictCode);
        if (bean == null) {
            return MapUtil.empty();
        }
        return this.toMap(bean);
    }

    private Map<String, Object> toMap(MultilevelTableBean bean) {
        Map rtn = BeanUtil.beanToMap((Object)bean, (boolean)true, (boolean)false);
        rtn.put("#bean#", bean);
        int maxLevel = 5;
        String type = bean.getBuilder_type();
        for (int i = 0; i < maxLevel; ++i) {
            String codeCol = "l" + i + "_code";
            String nameCol = "l" + i + "_name";
            String newCodeCol = type + "_l" + i + "_code";
            String newNameCol = type + "_l" + i + "_name";
            Object val = rtn.get(codeCol);
            if (val != null && PropertiesCommon.CONFIG.MDM_SET_LEVEL_DATA.getVal(bean.getEnt_id()).equalsIgnoreCase("N")) {
                String valStr = String.valueOf(val);
                val = valStr.contains("-") ? valStr.split("-")[1] : valStr;
            }
            rtn.put(newCodeCol, val);
            rtn.put(newNameCol, rtn.get(nameCol));
        }
        return rtn;
    }

    @Override
    public boolean hasType(String dictType) {
        return true;
    }

    @Override
    public String getMdmName(Map<String, Object> dict, String dictType) {
        MultilevelTableBean bean = this.getBean(dict);
        if (bean == null) {
            return "";
        }
        return bean.getName();
    }

    @Override
    public String getMdmNameCol(String dictType) {
        return null;
    }

    @Override
    public String getMdmPcodeCol(String dictType) {
        return null;
    }

    @Override
    public int getMaxLevel(String dictType) {
        return 0;
    }
}

