/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.fileio;

import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.jpeg.segments.UnknownSegment;

public class ImageTools {
    public static String getRealFormatName(Object object) throws Exception {
        ImageInputStream iis = ImageIO.createImageInputStream(object);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(iis);
        if (iterator.hasNext()) {
            ImageReader reader = iterator.next();
            return reader.getFormatName();
        }
        return null;
    }

    public static void convertTif(String fileName, String extension) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                System.out.println("File not exist!!!");
                return;
            }
            BufferedImage image = ImageIO.read(file);
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            convertedImage.createGraphics().drawRenderedImage(image, null);
            ImageIO.write((RenderedImage)convertedImage, extension, new File(fileName));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void buildThumbnailImage(BufferedImage img, OutputStream out, int w, int h) throws Exception {
        int newWidth = 0;
        int newHeight = 0;
        if (h > 0) {
            newWidth = w;
            newHeight = h;
        } else {
            int max = w;
            double ratio = 1.0;
            if (img.getHeight() > max || img.getWidth() > max) {
                ratio = img.getHeight() > img.getWidth() ? (double)max / (double)img.getHeight() : (double)max / (double)img.getWidth();
            }
            newWidth = (int)((double)img.getWidth() * ratio);
            newHeight = (int)((double)img.getHeight() * ratio);
        }
        BufferedImage _image = new BufferedImage(newWidth, newHeight, 1);
        Graphics graphics = _image.getGraphics();
        graphics.drawImage(img.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
        graphics.dispose();
        ImageIO.write((RenderedImage)_image, "jpeg", out);
    }

    public static String isImage(String filename) {
        String fn = filename.toLowerCase();
        if (fn.endsWith(".jpg") || fn.endsWith(".png") || fn.endsWith(".gif")) {
            return filename.substring(filename.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static BufferedImage readImage(File file) throws IOException, ImageReadException {
        boolean hasAdobeMarker = false;
        ImageInputStream stream = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (iter.hasNext()) {
            BufferedImage image;
            ImageReader reader = iter.next();
            reader.setInput(stream);
            ICC_Profile profile = null;
            try {
                image = reader.read(0);
            }
            catch (IIOException e) {
                hasAdobeMarker = ImageTools.checkAdobeMarker(file);
                profile = Sanselan.getICCProfile((File)file);
                WritableRaster raster = (WritableRaster)reader.readRaster(0, null);
                if (hasAdobeMarker) {
                    ImageTools.convertInvertedColors(raster);
                }
                image = ImageTools.convertCmykToRgb(raster, profile);
            }
            return image;
        }
        return null;
    }

    public static BufferedImage readCMYKStream(InputStream in, byte[] bytes) throws IOException, ImageReadException {
        ImageInputStream stream = ImageIO.createImageInputStream(in);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (iter.hasNext()) {
            ImageReader reader = iter.next();
            reader.setInput(stream);
            boolean hasAdobeMarker = ImageTools.checkAdobeMarker(new ByteSourceArray(bytes));
            ICC_Profile profile = Sanselan.getICCProfile((byte[])bytes);
            WritableRaster raster = (WritableRaster)reader.readRaster(0, null);
            if (hasAdobeMarker) {
                ImageTools.convertInvertedColors(raster);
            }
            BufferedImage image = ImageTools.convertCmykToRgb(raster, profile);
            return image;
        }
        return null;
    }

    private static boolean checkAdobeMarker(Object obj) throws IOException, ImageReadException {
        JpegImageParser parser = new JpegImageParser();
        Object byteSource = null;
        byteSource = obj instanceof File ? new ByteSourceFile((File)obj) : (ByteSource)obj;
        ArrayList segments = parser.readSegments(byteSource, new int[]{65518}, true);
        if (segments != null && segments.size() >= 1) {
            UnknownSegment app14Segment = (UnknownSegment)segments.get(0);
            byte[] data = app14Segment.bytes;
            if (data.length >= 12 && data[0] == 65 && data[1] == 100 && data[2] == 111 && data[3] == 98 && data[4] == 101) {
                return true;
            }
        }
        return false;
    }

    private static void convertInvertedColors(WritableRaster raster) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * 4;
        int[] pixelRow = new int[stride];
        for (int h = 0; h < height; ++h) {
            raster.getPixels(0, h, width, 1, pixelRow);
            for (int x = 0; x < stride; ++x) {
                pixelRow[x] = 255 - pixelRow[x];
            }
            raster.setPixels(0, h, width, 1, pixelRow);
        }
    }

    private static BufferedImage convertCmykToRgb(Raster cmykRaster, ICC_Profile cmykProfile) throws IOException {
        if (cmykProfile == null) {
            cmykProfile = ICC_Profile.getInstance(ImageTools.class.getResourceAsStream("ISOcoated_v2_300_eci.icc"));
        }
        ICC_ColorSpace cmykCS = new ICC_ColorSpace(cmykProfile);
        BufferedImage rgbImage = new BufferedImage(cmykRaster.getWidth(), cmykRaster.getHeight(), 1);
        WritableRaster rgbRaster = rgbImage.getRaster();
        ColorSpace rgbCS = rgbImage.getColorModel().getColorSpace();
        ColorConvertOp cmykToRgb = new ColorConvertOp(cmykCS, rgbCS, null);
        cmykToRgb.filter(cmykRaster, rgbRaster);
        return rgbImage;
    }

    public static void main(String[] args) {
        try {
            BufferedImage image = ImageTools.readImage(new File("g:\\1-111201142T6.jpg"));
            System.out.println(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

