/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageExtract {
    public static String getHelpString(String[] args) {
        String result = String.format("%s [path]", "a");
        return result;
    }

    private void getFiles(String rootPath, final String fileExt, List<File> fileList) {
        File[] list;
        File f = new File(rootPath);
        for (File fn : list = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean ret = f.isDirectory() || f.isFile() && f.getName().endsWith(fileExt);
                return ret;
            }
        })) {
            if (fn.isDirectory()) {
                this.getFiles(fn.getAbsolutePath(), fileExt, fileList);
                continue;
            }
            fileList.add(fn);
        }
    }

    public List<File> run(String rootPath, String fileExt) {
        LinkedList<File> result = new LinkedList<File>();
        this.getFiles(rootPath, fileExt, result);
        return result;
    }

    public List<String> parserSourceFile(List<String> patternList, File file, int miniCharCount) throws Exception {
        LinkedList<String> result = new LinkedList<String>();
        BufferedReader r = new BufferedReader(new FileReader(file));
        char[] buffer = new char[(int)file.length()];
        r.read(buffer, 0, (int)file.length());
        String text = new String(buffer, 0, buffer.length);
        for (String patternStr : patternList) {
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matchers = pattern.matcher(text);
            while (matchers.find()) {
                String t = matchers.group();
                if (t.length() < miniCharCount) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            StringBuilder sb = new StringBuilder().append("\u672a\u4f20\u5165\u9700\u8981\u641c\u7d22\u7684\u6709\u6548\u7684\u6e90\u4ee3\u7801\u8def\u5f84").append("\n").append(MessageExtract.getHelpString(args));
            System.out.println(sb.toString());
            System.exit(1);
        }
        ArrayList<String> searchFolders = new ArrayList<String>(100);
        for (int i = 0; i <= args.length - 1; ++i) {
            File f = new File(args[i]);
            if (!f.isDirectory() || !f.exists()) continue;
            searchFolders.add(f.getAbsolutePath());
        }
        LinkedList<String> patternList = new LinkedList<String>();
        patternList.add("'([\\u4E00-\\u9FA5]+)'");
        patternList.add("\"([\\u4E00-\\u9FA5]+)\"");
        patternList.add("\".*\\{0\\}.*\"");
        MessageExtract es = new MessageExtract();
        ArrayList<File> fileList = new ArrayList<File>(1000);
        for (String sarchFolder : searchFolders) {
            List<File> t = es.run(sarchFolder, ".java");
            fileList.addAll(t);
        }
        HashSet<String> outList = new HashSet<String>();
        for (File f : fileList) {
            try {
                List<String> items = es.parserSourceFile(patternList, f, 5);
                outList.addAll(items);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String str : outList) {
            System.out.println(str);
        }
    }
}

