/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.log4j;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.log4j.PlumeLogAppenderInstance;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.springframework.util.StringUtils;

@Plugin(name="PlumeLogAppender", category="Core", elementType="appender", printObject=true)
public class PlumeLogAppender
extends AbstractAppender {
    private AbstractAppender redisAppender;
    private AbstractAppender liteAppender;
    private final String mode;

    protected PlumeLogAppender(String name, String appName, String env, String mode, String cfg, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.mode = mode;
        if ("lite".equalsIgnoreCase(mode) || "redis".equalsIgnoreCase(mode)) {
            System.out.println("PlumeLogAppender mode: " + mode);
            System.out.println("PlumeLogAppender app : " + appName);
            System.out.println("PlumeLogAppender env : " + env);
            String runModel = null;
            String expand = null;
            int maxCount = 100;
            int logQueueSize = 10000;
            int threadPoolSize = 1;
            boolean compressor = false;
            String plumelogHost = "plumeloghost:8891";
            String redisHost = "pluemlogredis:6379";
            String redisPort = null;
            String redisAuth = null;
            int redisDb = 0;
            String model = "standalone";
            String masterName = null;
            if (!StringUtils.isEmpty((Object)cfg)) {
                if (!((String)cfg).startsWith("{")) {
                    cfg = "{" + (String)cfg + "}";
                }
                JSONObject json = JSONObject.parseObject((String)cfg);
                System.out.println("PlumeLogAppender cfg : " + json.toJSONString());
                if (json.containsKey((Object)"runModel")) {
                    runModel = json.getString("runModel");
                }
                if (json.containsKey((Object)"expand")) {
                    expand = json.getString("expand");
                }
                if (json.containsKey((Object)"maxCount")) {
                    maxCount = json.getInteger("maxCount");
                }
                if (json.containsKey((Object)"logQueueSize")) {
                    logQueueSize = json.getInteger("logQueueSize");
                }
                if (json.containsKey((Object)"threadPoolSize")) {
                    threadPoolSize = json.getInteger("threadPoolSize");
                }
                if (json.containsKey((Object)"compressor")) {
                    compressor = json.getBoolean("compressor");
                }
                if (json.containsKey((Object)"model")) {
                    model = json.getString("model");
                }
                if (json.containsKey((Object)"plumelogHost")) {
                    plumelogHost = json.getString("plumelogHost");
                }
                if (json.containsKey((Object)"redisHost")) {
                    redisHost = json.getString("redisHost");
                }
                if (json.containsKey((Object)"redisPort")) {
                    redisPort = json.getString("redisPort");
                }
                if (json.containsKey((Object)"redisAuth")) {
                    redisAuth = json.getString("redisAuth");
                }
                if (json.containsKey((Object)"redisDb")) {
                    redisDb = json.getInteger("redisDb");
                }
                if (json.containsKey((Object)"masterName")) {
                    masterName = json.getString("masterName");
                }
            }
            if ("lite".equalsIgnoreCase(mode)) {
                this.liteAppender = new PlumeLogAppenderInstance().createAppenderForLite(name, appName, env, plumelogHost, maxCount, runModel, expand, logQueueSize, threadPoolSize, compressor, model, masterName, layout, filter);
            } else if ("redis".equalsIgnoreCase(mode)) {
                this.redisAppender = new PlumeLogAppenderInstance().createAppenderForRedis(name, appName, env, redisHost, redisPort, redisAuth, maxCount, runModel, expand, redisDb, logQueueSize, threadPoolSize, compressor, model, masterName, layout, filter);
            }
        } else {
            System.out.println("PlumeLogAppender ignore.");
        }
    }

    @PluginFactory
    public static PlumeLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="env") String env, @PluginAttribute(value="mode") String mode, @PluginAttribute(value="cfg") String cfg, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        return new PlumeLogAppender(name, appName, env, mode, cfg, filter, layout, true);
    }

    public void append(LogEvent logEvent) {
        if ("lite".equalsIgnoreCase(this.mode)) {
            this.liteAppender.append(logEvent);
        } else if ("redis".equalsIgnoreCase(this.mode)) {
            this.redisAppender.append(logEvent);
        }
    }

    private static interface ModeConstant {
        public static final String LITE = "lite";
        public static final String REDIS = "redis";
    }
}

