/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.proxy;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.proxy.EnterpriseProxyBase;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class EnterpriseProxy {
    private static final String BEAN_NAME = "entconfig";
    private String bizKey;
    private String bizpara1;
    private String bizpara2;
    private String bizpara3;
    private String bizpara4;
    private String bizpara5;
    private ConcurrentHashMap<Long, EnterpriseConfigBean> list_enterprise = new ConcurrentHashMap();

    public static EnterpriseProxy getInstance() {
        if (!SpringBeanFactory.containsBean(BEAN_NAME)) {
            return null;
        }
        EnterpriseProxy eas = SpringBeanFactory.getBean(BEAN_NAME, EnterpriseProxy.class);
        if (eas == null) {
            return null;
        }
        return eas;
    }

    public String getBizKey() {
        return this.bizKey;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    public FStorageOperations getStorageOperations() {
        return SpringBeanFactory.getBean("GlobalStorageOperation", FStorageOperations.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initEnterpriseConfig() throws Exception {
        FMybatisTemplate storage = null;
        try {
            this.list_enterprise.clear();
            storage = (FMybatisTemplate)this.getStorageOperations();
            Query query = new Query();
            List list = storage.select(query, EnterpriseConfigBean.class);
            for (EnterpriseConfigBean ent : list) {
                this.list_enterprise.put(ent.getEnt_id(), ent);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return this.list_enterprise.size();
    }

    public JSONObject printEnterpriseConfig(long ent_id) throws Exception {
        JSONObject ret = new JSONObject();
        if (StringUtils.isEmpty(this.list_enterprise) || this.list_enterprise.size() <= 0) {
            this.initEnterpriseConfig();
        }
        if (ent_id == 0L) {
            ret.put("ents", (Object)JSONObject.toJSONString(this.list_enterprise));
        } else {
            ret.put(String.valueOf(ent_id), (Object)JSONObject.toJSONString((Object)this.list_enterprise.get(ent_id)));
        }
        return ret;
    }

    private EnterpriseConfigBean getEnterpriseConfig(long ent_id) throws Exception {
        EnterpriseConfigBean ent = this.list_enterprise.get(ent_id);
        if (StringUtils.isEmpty((Object)ent)) {
            this.initEnterpriseConfig();
            if (this.list_enterprise == null || this.list_enterprise.size() <= 0) {
                return ent;
            }
        }
        return this.list_enterprise.get(ent_id);
    }

    public Object getServiceProxy(ServiceSession session) throws Exception {
        this.setBizKey(this.bizKey);
        return this.getServiceProxy(session, this.bizKey);
    }

    public Object getServiceProxy(ServiceSession session, String bizKey) throws Exception {
        return this.getServiceProxy(session, bizKey, true);
    }

    public Object getServiceProxy(ServiceSession session, String bizKey, boolean isCheck) throws Exception {
        try {
            long ent_id = session.getEnt_id();
            EnterpriseConfigBean ent = null;
            try {
                ent = this.getEnterpriseConfig(ent_id);
            }
            catch (Exception Ex) {
                throw new ServiceException("50000", "\u52a0\u8f7d\u4ee3\u7406\u914d\u7f6e\u5931\u8d25:" + Ex.getMessage(), new Object[0]);
            }
            if (StringUtils.isEmpty((Object)ent)) {
                throw new ServiceException("50000", "\u672a\u627e\u5230\u4f01\u4e1a[" + String.valueOf(ent_id) + "]\u5bf9\u5e94\u7684\u4ee3\u7406\u914d\u7f6e\uff01", new Object[0]);
            }
            String proxyObject = ent.getProxyObject(bizKey);
            if (StringUtils.isEmpty((Object)proxyObject)) {
                throw new ServiceException("50000", "\u672a\u914d\u7f6e\u4ee3\u7406\u5bf9\u8c61[" + bizKey + "]!", new Object[0]);
            }
            if (!SpringBeanFactory.containsBean(proxyObject)) {
                throw new ServiceException("50000", "\u672a\u5305\u542b\u4ee3\u7406\u5bf9\u8c61[" + proxyObject + "]!", new Object[0]);
            }
            EnterpriseProxyBase eas = (EnterpriseProxyBase)SpringBeanFactory.getBean(proxyObject);
            if (eas == null) {
                throw new ServiceException("50000", "\u672a\u5b9a\u4e49\u4ee3\u7406\u5bf9\u8c61[" + proxyObject + "]!", new Object[0]);
            }
            eas.setBizKey(bizKey);
            eas.setEnterpise(ent);
            return eas;
        }
        catch (Exception ex) {
            if (isCheck) {
                throw ex;
            }
            return null;
        }
    }

    public ServiceResponse initconfig(ServiceSession session, JSONObject jsonparam) throws Exception {
        return ServiceResponse.buildSuccess(this.initEnterpriseConfig());
    }

    public ServiceResponse printconfig(ServiceSession session, JSONObject jsonparam) throws Exception {
        long ent_id = DataUtils.nvl(session.getEnt_id(), 0L);
        return ServiceResponse.buildSuccess(this.printEnterpriseConfig(ent_id));
    }

    public String getEnterpriseConfig(long ent_id, String key, boolean checkNull, String defValue) throws Exception {
        EnterpriseConfigBean ent = null;
        try {
            ent = this.getEnterpriseConfig(ent_id);
        }
        catch (Exception Ex) {
            throw new ServiceException("50000", "\u52a0\u8f7d\u4ee3\u7406\u914d\u7f6e\u5931\u8d25:" + Ex.getMessage(), new Object[0]);
        }
        if (StringUtils.isEmpty((Object)ent)) {
            throw new ServiceException("50000", "\u672a\u627e\u5230\u4f01\u4e1a[" + String.valueOf(ent_id) + "]\u5bf9\u5e94\u7684\u4ee3\u7406\u914d\u7f6e\uff01", new Object[0]);
        }
        return ent.getSrvConfig(key, checkNull, defValue);
    }

    public String getEnterpriseConfig(ServiceSession session, String key, boolean checkNull, String defValue) throws Exception {
        return this.getEnterpriseConfig(session.getEnt_id(), key, checkNull, defValue);
    }

    public String getBizpara1() {
        return this.bizpara1;
    }

    public void setBizpara1(String bizpara1) {
        this.bizpara1 = bizpara1;
    }

    public String getBizpara2() {
        return this.bizpara2;
    }

    public void setBizpara2(String bizpara2) {
        this.bizpara2 = bizpara2;
    }

    public String getBizpara3() {
        return this.bizpara3;
    }

    public void setBizpara3(String bizpara3) {
        this.bizpara3 = bizpara3;
    }

    public String getBizpara4() {
        return this.bizpara4;
    }

    public void setBizpara4(String bizpara4) {
        this.bizpara4 = bizpara4;
    }

    public String getBizpara5() {
        return this.bizpara5;
    }

    public void setBizpara5(String bizpara5) {
        this.bizpara5 = bizpara5;
    }
}

