/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.RestClientUtils;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component(value="RestClientUtils_SMG")
public class RestClientUtils_SMG
extends RestClientUtils {
    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param, new defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            try {
                JSONObject json = JSON.parseObject((String)((String)result));
                response = ServiceResponse.buildSuccess(json);
            }
            catch (Exception ex) {
                throw new ServiceException("50000", "Result data error:" + result, new Object[0]);
            }
        } else {
            throw new ServiceException("50000", "Result is null!", new Object[0]);
        }
        return response;
    }

    public class defaultRequestCallback
    implements RestClientUtils.requestCallback {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception {
            WebTarget taget = client.target(url);
            Response resp = null;
            Invocation.Builder invocationBuilder = taget.request();
            if (param instanceof byte[]) {
                invocationBuilder.header("Content-Encoding", (Object)"gzip");
                resp = invocationBuilder.post(Entity.entity((Object)param, (String)"application/octet-stream"));
            } else {
                resp = param instanceof JSON ? invocationBuilder.post(Entity.entity((Object)param, (String)"application/json")) : invocationBuilder.post(Entity.entity((Object)param, (MediaType)MediaType.TEXT_PLAIN_TYPE));
            }
            return resp.readEntity(String.class);
        }
    }
}

