/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.slice.filter;

import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.slice.entity.SplitConfigBean;
import com.efuture.ocp.common.slice.entity.SplitTableConfigBean;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class SliceBase {
    public static int MAPPED_STATEMENT_INDEX = 0;
    public static int PARAMETER_INDEX = 1;
    public static int ROWBOUNDS_INDEX = 2;
    public static int RESULT_HANDLER_INDEX = 3;
    public static int CACHEKEY_INDEX = 4;
    public static int BOUNDSQL_INDEX = 5;
    protected static Logger logger = LoggerFactory.getLogger(SliceBase.class);
    private static Boolean isDebugLog = null;
    private static Boolean isEnableSlice = null;
    private static String noFindError = null;
    private static int reloadTime = 0;
    private static String CACHE_PREFIX = "OCP:SliceBase:";
    private static List<String> LIST_ParaTable = Arrays.asList("splitconfig", "splittableconfig");

    public static FStorageOperations getStorageOperations() {
        return SpringBeanFactory.getBean("GlobalStorageOperation", FStorageOperations.class);
    }

    public static String print() {
        if (SliceBase.getOrganizationMap() == null) {
            return "NULL";
        }
        return SliceBase.getOrganizationMap().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getCollectionMap() {
        String key = CACHE_PREFIX.concat("collectionMap");
        Map result = (Map)CacheUtils.getInMemUtils("OBJ").getData(key);
        if (result == null) {
            String string = key;
            synchronized (string) {
                result = (Map)CacheUtils.getInMemUtils("OBJ").getData(key);
                if (result == null) {
                    HashMap<String, String> collectionMap = new HashMap<String, String>();
                    List list = SliceBase.getStorageOperations().select(new Query(), SplitTableConfigBean.class);
                    if (list != null && list.size() > 0) {
                        list.stream().forEach(config -> collectionMap.put(config.getSplitTableName(), config.getFieldName()));
                    }
                    System.out.println("collectionMap size: " + String.valueOf(list.size()) + " , " + String.valueOf(collectionMap.size()));
                    CacheUtils.getInMemUtils("OBJ").putData(key, collectionMap, SliceBase.reloadTime());
                    return collectionMap;
                }
            }
            if (result == null) {
                System.out.println("collectionMap is Null, \u5206\u7247\u4fe1\u606f\u5f02\u5e38");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getOrganizationMap() {
        String key = CACHE_PREFIX.concat("organizationMap");
        Map result = (Map)CacheUtils.getInMemUtils("OBJ").getData(key);
        if (result == null) {
            String string = key;
            synchronized (string) {
                result = (Map)CacheUtils.getInMemUtils("OBJ").getData(key);
                if (result == null) {
                    HashMap<String, String> organizationMap = new HashMap<String, String>();
                    List list = SliceBase.getStorageOperations().select(new Query(), SplitConfigBean.class);
                    if (list != null && list.size() > 0) {
                        list.stream().forEach(config -> organizationMap.put(config.getEntMarket(), config.getSplitCode()));
                    }
                    System.out.println("organizationMap size: " + String.valueOf(list.size()) + " , " + String.valueOf(organizationMap.size()));
                    CacheUtils.getInMemUtils("OBJ").putData(key, organizationMap, SliceBase.reloadTime());
                    return organizationMap;
                }
            }
            if (result == null) {
                System.out.println("organizationMap is Null, \u5206\u7247\u4fe1\u606f\u5f02\u5e38");
            }
        }
        return result;
    }

    public static Set<String> getAllSlice() {
        Map<String, String> all_orgs = SliceBase.getOrganizationMap();
        if (all_orgs == null || all_orgs.size() <= 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, String> entry : all_orgs.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    public static int reloadTime() {
        if (reloadTime == 0) {
            reloadTime = Integer.parseInt(EnviromentUtil.getProperty("efuture.slice.reload", "300"));
        }
        return reloadTime;
    }

    public static boolean isEnableSlice() {
        if (isEnableSlice == null) {
            isEnableSlice = "true".equalsIgnoreCase(EnviromentUtil.getProperty("efuture.slice.enable", "false"));
        }
        return isEnableSlice;
    }

    public static boolean isDebugLog() {
        if (isDebugLog == null) {
            isDebugLog = "true".equalsIgnoreCase(EnviromentUtil.getProperty("efuture.slice.debuglog", "false"));
        }
        return isDebugLog;
    }

    public static String getNoFindError() {
        if (noFindError == null && "true".equalsIgnoreCase(noFindError = EnviromentUtil.getProperty("efuture.slice.nofinderror", "true"))) {
            noFindError = "m$eventscopeitem";
        }
        return noFindError;
    }

    public static boolean isNoFindErrorTable(String sqlStatement) {
        String err = SliceBase.getNoFindError();
        if (StringUtils.isEmpty((Object)err) || "false".equalsIgnoreCase(err)) {
            return false;
        }
        String[] ss = err.split(",");
        for (int i = 0; i < ss.length; ++i) {
            if (sqlStatement.indexOf(ss[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isParaTable(String sqlStatement) {
        for (String table : LIST_ParaTable) {
            if (sqlStatement.indexOf(table) <= 0) continue;
            return true;
        }
        return false;
    }

    protected static void sliceFilterLog(String logmsg, Object ... args) {
        if (SliceBase.isDebugLog()) {
            logger.info(logmsg, args);
        }
    }

    public static void setCurrentSlice(String slice) {
        ServiceRestReflect.getLocale().get().setSlice(slice);
    }

    public static String getCurrentSlice() {
        return ServiceRestReflect.getLocale().get().getSlice();
    }

    public static String getCurrentEntMarket() {
        return ServiceRestReflect.getLocale().get().getEntMarket();
    }

    public static interface SliceStatus {
        public static final String READ = "read";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
    }
}

