/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.sysparam;

import com.efuture.ocp.common.util.EnvironmentParaUtils;
import org.springframework.util.StringUtils;

public interface SystemParam {
    public String getNamePrefix();

    public String getName();

    public String getDesc();

    public String getDefaultVal();

    default public String getKey() {
        Object name = this.getName();
        if (!StringUtils.isEmpty((Object)this.getNamePrefix())) {
            name = this.getNamePrefix() + "." + (String)name;
        }
        return name;
    }

    default public String getVal() {
        return this.getVal(0L);
    }

    default public String getVal(long entId) {
        String key = this.getKey();
        return EnvironmentParaUtils.getEnvPra(entId, key, this.getDefaultVal());
    }

    default public String getVal(String defaultVal) {
        return this.getVal(0L, "", defaultVal);
    }

    default public String getVal(long entId, String postfix) {
        return this.getVal(entId, postfix, this.getDefaultVal());
    }

    default public String getVal(long entId, String postfix, String defaultVal) {
        Object key = this.getKey();
        if (!StringUtils.isEmpty((Object)postfix)) {
            key = (String)key + "." + postfix;
        }
        return EnvironmentParaUtils.getEnvPra(entId, (String)key, defaultVal);
    }

    default public <T> T getVal(Class<T> targetType, T defaultVal) {
        return this.getVal(0L, "", targetType, defaultVal);
    }

    default public <T> T getVal(long entId, Class<T> targetType, T defaultVal) {
        return this.getVal(entId, "", targetType, defaultVal);
    }

    default public <T> T getVal(long entId, String postfix, Class<T> targetType, T defaultVal) {
        Object key = this.getKey();
        if (!StringUtils.isEmpty((Object)postfix)) {
            key = (String)key + "." + postfix;
        }
        return EnvironmentParaUtils.getEnvPra(entId, (String)key, targetType, defaultVal);
    }

    default public int getDefaultIntVal() {
        if (!StringUtils.isEmpty((Object)this.getDefaultVal())) {
            return Integer.valueOf(this.getDefaultVal());
        }
        return 0;
    }

    default public int convertToInt(String val) {
        if (!StringUtils.isEmpty((Object)val)) {
            return Integer.valueOf(val);
        }
        return 0;
    }

    default public int getIntVal() {
        return this.getIntVal(0L);
    }

    default public int getIntVal(long entId) {
        String val = this.getVal(entId);
        return this.convertToInt(val);
    }

    default public int getIntVal(long entId, String postfix) {
        String val = this.getVal(entId, postfix);
        return this.convertToInt(val);
    }

    default public int getIntVal(long entId, String postfix, int defaultVal) {
        String val = this.getVal(entId, postfix, String.valueOf(defaultVal));
        return this.convertToInt(val);
    }
}

