/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.efuture.ocp.common.task.CallBackHandle;
import com.efuture.ocp.common.task.StepContext;
import com.efuture.ocp.common.task.StepHandle;
import com.efuture.ocp.common.task.TaskEntity;
import com.efuture.ocp.common.task.TaskPublic;
import com.efuture.ocp.common.task.TaskResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskContext {
    Long entId;
    String taskKey;
    String taskType;
    String taskCode;
    String rootTaskKey;
    String upperTaskKey;
    int taskLevel;
    String taskPath;
    String taskDesc;
    int taskStatus;
    int taskRunCount;
    String taskMsg;
    Date taskBizDate;
    List<String> completedSteps;
    List<StepContext> stepList;
    Map<String, Object> param;
    Map<String, Object> config;
    Long lastExecId;
    Date lastExecStart;
    Date lastExecEnd;
    Long curExecId;
    Date curExecStart;
    Date curExecEnd;
    TaskResult curResult;
    private TaskEntity taskEntity;
    private CallBackHandle callback;

    public TaskContext() {
    }

    public TaskEntity toTaskEntity() {
        if (this.taskEntity == null) {
            this.taskEntity = new TaskEntity();
            this.taskEntity.setEntId(this.entId);
            this.taskEntity.setTaskCode(this.taskCode);
            this.taskEntity.setTaskDesc(this.taskDesc);
            this.taskEntity.setTaskKey(this.taskKey);
            this.taskEntity.setTaskType(this.taskType);
            this.taskEntity.setConfig(JSONUtil.toJsonStr(this.config));
            this.taskEntity.setParam(JSONUtil.toJsonStr(this.param));
            this.taskEntity.setTaskBizDate(this.taskBizDate);
        }
        this.taskEntity.setCompletedSteps(JSONUtil.toJsonStr(this.completedSteps));
        this.taskEntity.setCurExecId(this.curExecId);
        this.taskEntity.setCurExecStart(this.curExecStart);
        this.taskEntity.setCurExecEnd(this.curExecEnd);
        this.taskEntity.setTaskStatus(this.taskStatus);
        this.taskEntity.setTaskMsg(this.taskMsg);
        return this.taskEntity;
    }

    public TaskContext(long entId, String taskCode, String taskName, String taskType, String taskKey, String taskBizDate) {
        this.entId = entId;
        this.taskKey = taskKey;
        this.taskType = taskType;
        this.taskCode = taskCode;
        this.taskDesc = taskName;
        this.taskBizDate = DateUtil.parseDate((CharSequence)taskBizDate);
    }

    public Long getEntId() {
        return this.entId;
    }

    public void setEntId(Long entId) {
        this.entId = entId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskCode() {
        return this.taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getRootTaskKey() {
        return this.rootTaskKey;
    }

    public void setRootTaskKey(String rootTaskKey) {
        this.rootTaskKey = rootTaskKey;
    }

    public String getUpperTaskKey() {
        return this.upperTaskKey;
    }

    public void setUpperTaskKey(String upperTaskKey) {
        this.upperTaskKey = upperTaskKey;
    }

    public int getTaskLevel() {
        return this.taskLevel;
    }

    public void setTaskLevel(int taskLevel) {
        this.taskLevel = taskLevel;
    }

    public String getTaskPath() {
        return this.taskPath;
    }

    public void setTaskPath(String taskPath) {
        this.taskPath = taskPath;
    }

    public String getTaskDesc() {
        return this.taskDesc;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public int getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(int taskStatus) {
        this.taskStatus = taskStatus;
    }

    public int getTaskRunCount() {
        return this.taskRunCount;
    }

    public void setTaskRunCount(int taskRunCount) {
        this.taskRunCount = taskRunCount;
    }

    public String getTaskMsg() {
        return this.taskMsg;
    }

    public void setTaskMsg(String taskMsg) {
        this.taskMsg = taskMsg;
    }

    public Date getTaskBizDate() {
        return this.taskBizDate;
    }

    public void setTaskBizDate(Date taskBizDate) {
        this.taskBizDate = taskBizDate;
    }

    public List<StepContext> getStepList() {
        return this.stepList;
    }

    public void setStepList(List<StepContext> stepList) {
        this.stepList = stepList;
    }

    public Map<String, Object> getParam() {
        if (this.param == null) {
            this.param = new HashMap<String, Object>();
        }
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public Long getLastExecId() {
        return this.lastExecId;
    }

    public void setLastExecId(Long lastExecId) {
        this.lastExecId = lastExecId;
    }

    public Date getLastExecStart() {
        return this.lastExecStart;
    }

    public void setLastExecStart(Date lastExecStart) {
        this.lastExecStart = lastExecStart;
    }

    public Date getLastExecEnd() {
        return this.lastExecEnd;
    }

    public void setLastExecEnd(Date lastExecEnd) {
        this.lastExecEnd = lastExecEnd;
    }

    public void setCurExecId(Long curExecId) {
        this.curExecId = curExecId;
    }

    public void setCurResult(TaskResult curResult) {
        this.curResult = curResult;
    }

    public TaskResult getCurResult() {
        return this.curResult;
    }

    public void setCurResult(TaskResult result, StepContext stepCtx) {
        this.curResult = result;
        if (result.isSuccess()) {
            this.addCompletedStep(stepCtx);
        } else {
            this.setTaskStatus(110);
            this.setTaskMsg(result.getMsg());
        }
    }

    public long getCurExecId() {
        return this.curExecId;
    }

    public void setCurExecId(long curExecId) {
        this.curExecId = curExecId;
    }

    public Date getCurExecStart() {
        return this.curExecStart;
    }

    public void setCurExecStart(Date curExecStart) {
        this.curExecStart = curExecStart;
    }

    public Date getCurExecEnd() {
        return this.curExecEnd;
    }

    public void setCurExecEnd(Date curExecEnd) {
        this.curExecEnd = curExecEnd;
    }

    public String getMsgKey() {
        return this.getTaskCode() + "-" + this.getTaskKey();
    }

    public boolean isComplete() {
        return this.taskStatus >= 100;
    }

    public boolean isSuccess() {
        return this.taskStatus == 100;
    }

    public CallBackHandle getCallback() {
        return this.callback;
    }

    public void setCallback(CallBackHandle callback) {
        this.callback = callback;
    }

    public void syncFromEntity(TaskEntity entity) {
        this.taskEntity = entity;
        this.taskStatus = entity.taskStatus;
        if (!StrUtil.isBlank((CharSequence)entity.completedSteps)) {
            this.completedSteps = JSONUtil.parseArray((String)entity.completedSteps).toList(String.class);
        }
        this.lastExecId = entity.curExecId;
        this.lastExecStart = entity.curExecStart;
        this.lastExecEnd = entity.curExecEnd;
        if (this.taskStatus > 100) {
            this.taskStatus = 1;
        }
    }

    public TaskContext addParam(String key, Object val) {
        if (this.param == null) {
            this.param = new HashMap<String, Object>();
        }
        this.param.put(key, val);
        return this;
    }

    public TaskContext addConfig(String key, Object val) {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        this.config.put(key, val);
        return this;
    }

    public void addCompletedStep(StepContext stepCtx) {
        if (stepCtx == null) {
            return;
        }
        if (this.completedSteps == null) {
            this.completedSteps = new ArrayList<String>();
        }
        this.completedSteps.add(stepCtx.stepCode);
    }

    public TaskContext addStep(StepContext stepCtx) {
        if (this.stepList == null) {
            this.stepList = new ArrayList<StepContext>();
        }
        if (stepCtx.getStep() == 0) {
            stepCtx.setStep(this.stepList.size() + 1);
        }
        this.stepList.add(stepCtx);
        return this;
    }

    public TaskContext addStep(String stepCode, String handleName) {
        StepContext step = new StepContext(stepCode, handleName, this);
        this.addStep(step);
        return this;
    }

    public TaskContext addStep(StepHandle handle) {
        StepContext step = new StepContext(handle.getStepCode(), handle, this);
        this.addStep(step);
        return this;
    }

    public TaskContext addStep(String stepCode, String handleName, Map<String, Object> param, Map<String, Object> config) {
        this.addStep(stepCode, handleName);
        this.addParam(stepCode, param);
        this.addConfig(stepCode, config);
        return this;
    }

    public void initCurExec() {
        this.curExecId = TaskPublic.createExecId();
        this.curExecStart = new Date();
    }

    public boolean isSuccessStep(String stepCode) {
        if (this.completedSteps == null) {
            return false;
        }
        return this.completedSteps.contains(stepCode);
    }

    public String getParam(String key, String defVal, boolean checkBlank) {
        String val = defVal;
        if (this.param != null) {
            val = MapUtil.getStr(this.param, (Object)key, (String)defVal);
        }
        if (StrUtil.isBlank((CharSequence)val)) {
            throw new RuntimeException("\u53c2\u6570[" + key + "]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return val;
    }

    public String getParam(String key, boolean checkBlank) {
        return this.getParam(key, null, checkBlank);
    }

    public void checkParamBlank(String key) {
        this.getParam(key, null, true);
    }

    static interface TASK_STATUS {
        public static final int not_start = 0;
        public static final int started = 1;
        public static final int executing = 10;
        public static final int success = 100;
        public static final int error = 110;
    }
}

