/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task.impl;

import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import com.efuture.ocp.common.task.TaskEntity;
import com.efuture.ocp.common.task.TaskPublic;
import com.efuture.ocp.common.task.TaskRepository;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DbTaskRepositoryImpl
implements TaskRepository {
    private String getTableName() {
        return "task_list";
    }

    private Db getDb() {
        DataSource ds = TaskPublic.getTaskDs();
        if (ds == null) {
            throw new RuntimeException("\u6ca1\u6709\u521b\u5efataskDS\u6570\u636e\u6e90");
        }
        return Db.use((DataSource)ds);
    }

    @Override
    public TaskEntity getLastTaskInfo(long entId, String taskCode) {
        return null;
    }

    @Override
    public TaskEntity getTaskInfoByTaskKey(long entId, String taskKey) {
        try {
            Entity rtn = this.getDb().get(Entity.create((String)this.getTableName()).set("ent_id", (Object)entId).set("task_key", (Object)taskKey));
            if (rtn == null) {
                return null;
            }
            return (TaskEntity)rtn.toBean(TaskEntity.class);
        }
        catch (SQLException th) {
            throw new RuntimeException("\u67e5\u8be2\u4efb\u52a1:" + taskKey + "\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38", th);
        }
    }

    @Override
    public void saveTask(TaskEntity taskEntity) {
        try {
            this.getDb().insert(Entity.create((String)this.getTableName()).parseBean((Object)taskEntity, true, true));
        }
        catch (SQLException th) {
            throw new RuntimeException("\u4fdd\u5b58\u4efb\u52a1:" + taskEntity.getTaskKey() + "\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38", th);
        }
    }

    @Override
    public void uptTaskStepStatus(TaskEntity taskEntity) {
        Entity record = this.createRecord(taskEntity, "task_status", "task_msg", "completed_steps");
        Entity where = this.createWhere(taskEntity);
        try {
            int row = this.getDb().update(record, where);
            if (row == 0) {
                throw new RuntimeException("\u66f4\u65b0\u6267\u884c\u6b65\u9aa4:" + taskEntity.getTaskKey() + "-" + taskEntity.getCurExecId() + "\u65f6\u5f02\u5e38,\u66f4\u65b0\u884c\u6570\u4e3a0,\u53ef\u80fd\u4efb\u52a1\u88ab\u5220\u9664");
            }
        }
        catch (SQLException th) {
            throw new RuntimeException("\u66f4\u65b0\u6267\u884c\u6b65\u9aa4:" + taskEntity.getTaskKey() + "\u72b6\u6001\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38", th);
        }
    }

    @Override
    public void uptTaskNotifyResult(TaskEntity taskEntity) {
        Entity record = this.createRecord(taskEntity, "notify_result");
        Entity where = this.createWhere(taskEntity);
        try {
            int row = this.getDb().update(record, where);
            if (row == 0) {
                throw new RuntimeException("\u66f4\u65b0\u56de\u8c03\u7ed3\u679c:" + taskEntity.getTaskKey() + "-" + taskEntity.getCurExecId() + "\u65f6\u5f02\u5e38,\u66f4\u65b0\u884c\u6570\u4e3a0,\u53ef\u80fd\u4efb\u52a1\u88ab\u5220\u9664");
            }
        }
        catch (SQLException th) {
            throw new RuntimeException("\u66f4\u65b0\u56de\u8c03\u7ed3\u679c:" + taskEntity.getTaskKey() + "\u72b6\u6001\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38", th);
        }
    }

    private Entity createWhere(TaskEntity taskEntity) {
        return Entity.create((String)this.getTableName()).set("ent_id", (Object)taskEntity.getEntId()).set("task_key", (Object)taskEntity.getTaskKey());
    }

    private Entity createRecord(TaskEntity taskEntity, String ... keys) {
        return Entity.create((String)this.getTableName()).parseBean((Object)taskEntity, true, false).filter(keys);
    }

    @Override
    public void startTask(TaskEntity taskEntity) {
        Entity record = this.createRecord(taskEntity, "task_status", "task_run_count", "cur_exec_id", "cur_exec_start", "cur_exec_end");
        Entity where = this.createWhere(taskEntity);
        try {
            int row = this.getDb().update(record, where);
            if (row == 0) {
                throw new RuntimeException("\u542f\u52a8\u4efb\u52a1:" + taskEntity.getTaskKey() + "\u65f6\u5f02\u5e38,\u66f4\u65b0\u884c\u6570\u4e3a0,\u53ef\u80fd\u4efb\u52a1\u88ab\u5220\u9664");
            }
        }
        catch (SQLException th) {
            throw new RuntimeException("\u542f\u52a8\u4efb\u52a1:" + taskEntity.getTaskKey() + "\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38", th);
        }
    }

    @Override
    public void completeTask(TaskEntity taskEntity) {
        Entity record = this.createRecord(taskEntity, "task_status", "task_msg", "cur_exec_end");
        Entity where = this.createWhere(taskEntity);
        try {
            int row = this.getDb().update(record, where);
            if (row == 0) {
                throw new RuntimeException("\u542f\u52a8\u4efb\u52a1:" + taskEntity.getTaskKey() + "\u65f6\u5f02\u5e38,\u66f4\u65b0\u884c\u6570\u4e3a0,\u53ef\u80fd\u4efb\u52a1\u88ab\u5220\u9664");
            }
        }
        catch (SQLException th) {
            throw new RuntimeException("\u7ed3\u675f\u4efb\u52a1:" + taskEntity.getTaskKey() + "\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38", th);
        }
    }
}

