/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.SpringBeanFactory;
import org.springframework.core.env.Environment;

public class EnvironmentParaUtils {
    public static Environment getEnvironment() {
        if (SpringBeanFactory.getContext() == null) {
            return null;
        }
        return (Environment)SpringBeanFactory.getContext().getBean(Environment.class);
    }

    public static String getEnvPra(String key, String defaultValue) {
        return EnvironmentParaUtils.getEnvPra(0L, key, defaultValue);
    }

    public static String getEnvPra(long entId, String key, String defaultValue) {
        Environment env = EnvironmentParaUtils.getEnvironment();
        if (env == null) {
            return defaultValue;
        }
        String value = EnvironmentParaUtils.get(env, entId, key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private static String get(Environment env, long entId, String key) {
        String entKey;
        if (entId != 0L && env.containsProperty(entKey = key + "-" + entId)) {
            return env.getProperty(entKey);
        }
        return env.getProperty(key);
    }

    public static <T> T getEnvPra(String key, Class<T> targetType, T defaultValue) {
        return EnvironmentParaUtils.getEnvPra(0L, key, targetType, defaultValue);
    }

    public static <T> T getEnvPra(long entId, String key, Class<T> targetType, T defaultValue) {
        String entKey;
        Environment env = EnvironmentParaUtils.getEnvironment();
        if (env == null) {
            return defaultValue;
        }
        if (entId != 0L && env.containsProperty(entKey = key + "-" + entId)) {
            return (T)env.getProperty(entKey, targetType, defaultValue);
        }
        return (T)env.getProperty(key, targetType, defaultValue);
    }
}

