/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.component.GlobRuleSrv;
import java.util.HashMap;
import java.util.Map;

public class KeyGen {
    private Map<Long, Key> mapkey = new HashMap<Long, Key>();
    private static ThreadLocal<Key> ThreadLocalKey = new ThreadLocal();
    private String ruleid;
    private long defaultcachenum = 20L;
    private GlobRuleSrv globrulesrv;

    public KeyGen(String ruleid, long defaultcachenum, GlobRuleSrv globrulesrv) {
        this.ruleid = ruleid;
        this.defaultcachenum = defaultcachenum;
        this.globrulesrv = globrulesrv;
    }

    public void setGlobrulesrv(GlobRuleSrv globrulesrv) {
        this.globrulesrv = globrulesrv;
    }

    public void setDefaultcachenum(long defaultcachenum) {
        this.defaultcachenum = defaultcachenum;
    }

    public String getRuleid() {
        return this.ruleid;
    }

    public void setRuleid(String ruleid) {
        this.ruleid = ruleid;
    }

    public long getNext(long ent_id) {
        long next = this.getThreadLocalNext(ent_id);
        if (next == 0L) {
            next = this.getpubnext(ent_id);
        }
        return next;
    }

    public void getbatch(long ent_id, long cachenum) {
        ThreadLocalKey.set(this.getnewkey(ent_id, cachenum, true));
    }

    private long getdblastno(long ent_id, long cachenum) {
        return this.globrulesrv.getlast(ent_id, this.ruleid, "#", "#", cachenum);
    }

    private long getpubnext(long ent_id) {
        return this.getpubkey(ent_id).getNext();
    }

    private long getThreadLocalNext(long ent_id) {
        Key thiskey = this.getThreadLocalKey(ent_id);
        if (null == thiskey) {
            return 0L;
        }
        return thiskey.getNext();
    }

    private Key getnewkey(long ent_id, long cachenum, boolean iblocal) {
        return new Key(cachenum, this.globrulesrv, iblocal, ent_id);
    }

    private Key getThreadLocalKey(long ent_id) {
        Key localkey = ThreadLocalKey.get();
        if (null == localkey) {
            return null;
        }
        return localkey;
    }

    private Key getpubkey(long ent_id) {
        Key thiskey = this.mapkey.get(ent_id);
        if (null == thiskey) {
            thiskey = this.putkeytomap(ent_id);
        }
        return thiskey;
    }

    private synchronized Key putkeytomap(long ent_id) {
        Key thiskey = this.mapkey.get(ent_id);
        if (null == thiskey) {
            thiskey = this.getnewkey(ent_id, this.defaultcachenum, false);
            this.mapkey.put(ent_id, thiskey);
        }
        return thiskey;
    }

    private class Key {
        private long cachenum = 0L;
        private long cur = 0L;
        private GlobRuleSrv globrulesrv;
        boolean iblocal;
        private long defaultcachenum;
        private long ent_id;

        public Key(long defaultcachenum, GlobRuleSrv globrulesrv, boolean iblocal, long ent_id) {
            this.defaultcachenum = defaultcachenum;
            this.globrulesrv = globrulesrv;
            this.iblocal = iblocal;
            this.ent_id = ent_id;
        }

        public long getCachenum() {
            return this.cachenum;
        }

        public void setCachenum(long cachenum) {
            this.cachenum = cachenum;
        }

        public synchronized void setCur(long cur) {
            this.cur = cur;
        }

        public synchronized long getNext() {
            if (this.cachenum <= 0L) {
                if (!this.iblocal || this.cur == 0L) {
                    this.cur = this.getdblastno(this.ent_id, this.defaultcachenum);
                    this.cachenum = this.defaultcachenum;
                } else {
                    return 0L;
                }
            }
            ++this.cur;
            --this.cachenum;
            return this.cur;
        }

        private long getdblastno(long ent_id, long cachenum) {
            return this.globrulesrv.getlast(ent_id, KeyGen.this.ruleid, "#", "#", cachenum);
        }
    }
}

