/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class NetworkUtils {
    public static String getLocalPort() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), null);
        if (objectNames == null || objectNames.size() <= 0) {
            throw new IllegalStateException("Cannot get the names of MBeans controlled by the MBean server.");
        }
        for (ObjectName objectName : objectNames) {
            String protocol = String.valueOf(mBeanServer.getAttribute(objectName, "protocol"));
            String port = String.valueOf(mBeanServer.getAttribute(objectName, "port"));
            if (!protocol.equals("HTTP/1.1") && !protocol.equals("org.apache.coyote.http11.Http11NioProtocol")) continue;
            return port;
        }
        throw new IllegalStateException("Failed to get the HTTP port of the current server");
    }

    public static String getLocalIP() throws Exception {
        InetAddress addr = InetAddress.getLocalHost();
        byte[] ipAddr = addr.getAddress();
        Object ipAddrStr = "";
        for (int i = 0; i < ipAddr.length; ++i) {
            if (i > 0) {
                ipAddrStr = (String)ipAddrStr + ".";
            }
            ipAddrStr = (String)ipAddrStr + (ipAddr[i] & 0xFF);
        }
        return ipAddrStr;
    }
}

