/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class VirtualFieldServiceImpl
extends BasicComponent {
    private int cacheDays;
    private Map<String, String> virtual_fields_config;
    private String VirtualFieldCacheKey = "HGO:VF:ENT:%s:F:%s";
    ThreadLocal<Map<String, Map>> fieldUnit = new ThreadLocal();

    public int getCacheDays() {
        return this.cacheDays;
    }

    public void setCacheDays(int cacheDays) {
        this.cacheDays = cacheDays;
    }

    public Map<String, String> getVirtual_fields_config() {
        return this.virtual_fields_config;
    }

    public void setVirtual_fields_config(Map<String, String> virtual_fields_config) {
        this.virtual_fields_config = virtual_fields_config;
    }

    public static VirtualFieldServiceImpl getInstance() {
        if (SpringBeanFactory.containsBean("VirtualFieldService")) {
            return SpringBeanFactory.getBean("VirtualFieldService", VirtualFieldServiceImpl.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExistVirtualField(ServiceSession session, JSONObject jsonparam) throws Exception {
        String virtual_fields = this.getParamWithCheck(jsonparam, "virtual_fields", false, "");
        String[] vfList = virtual_fields.split(",");
        HashMap unit = new HashMap();
        for (String kv : vfList) {
            String[] tmp = kv.split(":");
            if (tmp.length != 2) continue;
            String key = tmp[0];
            String display = tmp[1];
            if (!Arrays.asList(this.virtual_fields_config.get("field.list").split(",")).contains(key)) continue;
            String currentCacheKey = String.format(this.VirtualFieldCacheKey, session.getEnt_id(), tmp[0]);
            try {
                HashMap cacheData = (HashMap)CacheUtils.getRedisUtils().getData(currentCacheKey);
                if (cacheData == null && CacheUtils.getRedisUtils().tryLock(currentCacheKey + "LOCK", "LOCK", 10, 1000)) {
                    cacheData = new HashMap();
                    CacheUtils.getCacheUtils().putData(currentCacheKey, cacheData, 86400);
                }
            }
            finally {
                CacheUtils.getRedisUtils().releaseLock(currentCacheKey + "LOCK", 10, "LOCK");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("display", display);
            map.put("ent_id", session.getEnt_id());
            unit.put(key, map);
            this.fieldUnit.set(unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> handleVirtualField(List<Map<String, Object>> list) {
        try {
            Map<String, Map> unit = this.fieldUnit.get();
            if (unit != null && !unit.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Map<String, Object> result = list.get(i);
                    if (!result.keySet().containsAll(unit.keySet())) continue;
                    for (String key : unit.keySet()) {
                        if (!result.containsKey(key)) continue;
                        String code = String.valueOf(result.get(key));
                        Map map = unit.get(key);
                        String display = (String)map.get("display");
                        long ent_id = (Long)map.get("ent_id");
                        String currentCacheKey = String.format(this.VirtualFieldCacheKey, ent_id, key);
                        String displayValue = null;
                        try {
                            Map cacheData = (Map)CacheUtils.getRedisUtils().getData(currentCacheKey);
                            if (!cacheData.isEmpty()) {
                                displayValue = (String)cacheData.get(code);
                            }
                            ServiceLogs.debuglog("VIRTUAL", "currentCacheKey:".concat(currentCacheKey), 0L);
                            if (displayValue == null && CacheUtils.getRedisUtils().tryLock(currentCacheKey + "LOCK", "LOCK", 10, 1000)) {
                                String typeKey = key + ".type";
                                String dbKey = key + ".db";
                                String tableKey = key + ".table";
                                String whereKey = key + ".where";
                                String formatKey = key + ".format";
                                String dtcodeKey = key + ".dtcode";
                                String typeConf = this.virtual_fields_config.get(typeKey);
                                String dbConf = this.virtual_fields_config.get(dbKey);
                                String tableConf = this.virtual_fields_config.get(tableKey);
                                String whereConf = this.virtual_fields_config.get(whereKey);
                                String formatConf = this.virtual_fields_config.get(formatKey);
                                String dtcodeConf = this.virtual_fields_config.get(dtcodeKey);
                                String sql = "";
                                sql = "dict".equals(typeConf) ? this.parseDictSQL(dbConf, tableConf, whereConf, ent_id, dtcodeConf, code) : this.parseTableSQL(dbConf, tableConf, whereConf, ent_id, code);
                                ServiceLogs.debuglog("VIRTUAL", "SQL:".concat(sql), 0L);
                                Map<String, Object> rs = this.executionQuery(dbConf, sql, formatConf, cacheData, currentCacheKey, code);
                                if (rs == null && "dict".equals(typeConf)) {
                                    sql = this.parseDictSQL(dbConf, tableConf, whereConf, 0L, dtcodeConf, code);
                                    this.executionQuery(dbConf, sql, formatConf, cacheData, currentCacheKey, code);
                                }
                            }
                            ServiceLogs.debuglog("VIRTUAL", "result:".concat(result.toString()), 0L);
                            result.put(display, cacheData.get(code));
                        }
                        finally {
                            CacheUtils.getRedisUtils().releaseLock(currentCacheKey + "LOCK", 10, "LOCK");
                        }
                    }
                }
            }
            ServiceLogs.debuglog("VIRTUAL", "result:".concat(list.toString()), 0L);
            List<Map<String, Object>> list2 = list;
            return list2;
        }
        finally {
            if (this.fieldUnit.get() != null) {
                this.fieldUnit.remove();
            }
        }
    }

    protected String parseTableSQL(String dbConf, String tableConf, String whereConf, long ent_id, String code) {
        String[] whereCodes = whereConf.split(",");
        StringBuilder outWhere = new StringBuilder();
        for (String whereCode : whereCodes) {
            if (outWhere.length() > 0) {
                outWhere.append(" and ");
            }
            if (whereCode.equals("ent_id")) {
                outWhere.append(" ent_id = ").append(ent_id);
                continue;
            }
            outWhere.append(" " + whereCode + " = '" + code + "'");
        }
        if (tableConf.equals("custtype")) {
            if (outWhere.length() > 0) {
                outWhere.append(" and ");
            }
            outWhere.append(" parent_id = 'T' ");
        }
        if (dbConf == null) {
            return String.format("select * from %s where %s", tableConf, outWhere.toString());
        }
        return String.format("select * from %s.%s where %s", dbConf, tableConf, outWhere.toString());
    }

    protected String parseDictSQL(String dbConf, String tableConf, String whereConf, long ent_id, String key, String code) {
        String[] whereCodes = whereConf.split(",");
        StringBuilder outWhere = new StringBuilder();
        for (String whereCode : whereCodes) {
            if (outWhere.length() > 0) {
                outWhere.append(" and ");
            }
            if (whereCode.equals("ent_id")) {
                outWhere.append(" ent_id = ").append(ent_id);
                continue;
            }
            if (whereCode.equals("dict_group_code")) {
                outWhere.append(" " + whereCode + " = '" + key + "'");
                continue;
            }
            outWhere.append(" " + whereCode + " = '" + code + "'");
        }
        return String.format("select * from %s.%s where %s", dbConf, tableConf, outWhere.toString());
    }

    protected Map<String, Object> executionQuery(String sql, String formatConf, Map<String, String> cacheData, String currentCacheKey, String code) {
        return this.executionQuery(null, sql, formatConf, cacheData, currentCacheKey, code);
    }

    protected Map<String, Object> executionQuery(String dbConf, String sql, String formatConf, Map<String, String> cacheData, String currentCacheKey, String code) {
        int cacheTime = 86400;
        if (this.cacheDays > 0) {
            cacheTime = 86400 * this.cacheDays;
        }
        String db = "";
        db = !StringUtils.isEmpty((Object)dbConf) ? "StorageOperation_".concat(dbConf) : "StorageOperation";
        ServiceLogs.debuglog("VIRTUAL", "db:".concat(db), 0L);
        Map rs = StringUtils.isEmpty((Object)dbConf) ? (Map)this.getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate().selectOne("mybatis.sql.select", (Object)sql) : (Map)this.getStorageOperations(db, FMybatisTemplate.class).getSqlSessionTemplate().selectOne("mybatis.sql.select", (Object)sql);
        if (rs != null) {
            String outFormatVal = VirtualFieldServiceImpl.formatRs(formatConf, rs);
            cacheData.put(code, outFormatVal);
            CacheUtils.getCacheUtils().putData(currentCacheKey, cacheData, cacheTime);
            ServiceLogs.debuglog("VIRTUAL", "outFormatVal:".concat(outFormatVal), 0L);
        } else {
            ServiceLogs.debuglog("VIRTUAL", "code:".concat(code), 0L);
            cacheData.put(code, code);
            CacheUtils.getCacheUtils().putData(currentCacheKey, cacheData, cacheTime);
        }
        return rs;
    }

    private static String formatRs(String format, Map vals) {
        Matcher m = Pattern.compile("\\{\\w+\\}").matcher(format);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String param = m.group();
            Object value = vals.get(param.substring(1, param.length() - 1).trim());
            m.appendReplacement(sb, value == null ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

