/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.redis;

import com.efuture.ocp.common.cache.redis.ObjectBytesExchange;
import com.efuture.ocp.common.cache.redis.RedisConfig;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class JedisManager {
    private static final Log log = LogFactory.getLog(JedisManager.class);
    private static ShardedJedisPool pool;
    private static JedisPool jedisPool;
    private static GenericObjectPoolConfig poolConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> keys(String pattern) {
        Set set = null;
        try (Jedis jedis = jedisPool.getResource();){
            set = jedis.keys(pattern);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setString(String key, String str, int liveSeconds) {
        if (key == null || str == null) {
            return null;
        }
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = liveSeconds <= 0 ? jedis.set(JedisManager.encode(key), str) : jedis.setex(JedisManager.encode(key), liveSeconds, str);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String key) {
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.get(JedisManager.encode(key));
        }
        return ret;
    }

    public static long delString(String key) {
        return JedisManager.del(key);
    }

    public static long delStringNew(String key) {
        return JedisManager.del(JedisManager.encode(key));
    }

    public static long delObject(String key) {
        return JedisManager.del(key);
    }

    public static Object getObject(String key) {
        if (key == null) {
            return null;
        }
        byte[] ret = JedisManager.getBytes(key.getBytes());
        if (ret == null) {
            return null;
        }
        return ObjectBytesExchange.toObject(ret);
    }

    public static String setObject(String key, int seconds, Object obj) {
        if (key == null || obj == null) {
            return null;
        }
        byte[] byteObj = ObjectBytesExchange.toByteArray(obj);
        if (null == byteObj) {
            return null;
        }
        return JedisManager.setBytes(key.getBytes(), seconds, byteObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(byte[] key) {
        if (key == null) {
            return null;
        }
        byte[] ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.get(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setBytes(byte[] key, int seconds, byte[] bytes) {
        if (key == null || bytes == null) {
            return null;
        }
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = seconds <= 0 ? jedis.set(key, bytes) : jedis.setex(key, seconds, bytes);
        }
        return ret;
    }

    public static String encode(String str) {
        String ret = null;
        if (str != null) {
            try {
                ret = URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long del(byte[] key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.del(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long del(String key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.del(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long expire(String key, int seconds) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.expire(key, seconds);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lock(String key, int seconds) {
        if (seconds <= 0) {
            seconds = 21600;
        }
        boolean result = false;
        if (key == null) {
            return result;
        }
        ShardedJedis jedis = null;
        long currentTime = System.currentTimeMillis();
        long expireTime = currentTime + (long)(seconds * 1000);
        try {
            jedis = pool.getResource();
            if (jedis.setnx(JedisManager.encode(key), String.valueOf(expireTime)) == 1L) {
                result = true;
                jedis.expire(JedisManager.encode(key), seconds);
            } else {
                Long oldExpireTime = Long.valueOf(JedisManager.getString(key));
                if (oldExpireTime != null && currentTime > oldExpireTime + 300000L) {
                    JedisManager.del(JedisManager.encode(key));
                    if (jedis.setnx(JedisManager.encode(key), String.valueOf(expireTime)) == 1L) {
                        result = true;
                        jedis.expire(JedisManager.encode(key), seconds);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return result;
    }

    public static ShardedJedisPool getPool() {
        return pool;
    }

    private static void destroy() {
        if (pool != null) {
            try {
                pool.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close ShardedJedisPool ", (Throwable)ex);
            }
            pool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrByStr(String key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.incr(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decrByStr(String key, long integer) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.decrBy(key, integer);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double incrByFloat(String key, double integer) {
        if (key == null) {
            return 0.0;
        }
        double ret = 0.0;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.incrByFloat(key, integer);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decrByStr(String key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.decr(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrByByte(byte[] key) {
        if (key == null || key.length == 0) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.incr(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long rpush(String key, String value) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.rpush(key, new String[]{value});
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long llen(String key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.llen(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> lrange(String key, int start, int end) {
        ArrayList<String> ret = new ArrayList();
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.lrange(key, (long)start, (long)end);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lpop(String key) {
        if (key == null) {
            return null;
        }
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.lpop(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long ttl(String key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.ttl(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lpush(String key, String ... value) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.lpush(key, value);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> lrange(String key, long start, long end) {
        ArrayList<String> ret = new ArrayList();
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.lrange(key, start, end);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String rpop(String key) {
        if (key == null) {
            return null;
        }
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.rpop(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lrem(String key, long count, String value) {
        if (key == null) {
            return -1L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.lrem(key, count, value);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ltrim(String key, long start, long end) {
        if (key == null) {
            return null;
        }
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.ltrim(key, start, end);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> spop(String key, long count) {
        if (key == null) {
            return null;
        }
        Set ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.spop(key, count);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> smembers(String key) {
        if (key == null) {
            return null;
        }
        Set ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.smembers(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String spop(String key) {
        if (key == null) {
            return null;
        }
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.spop(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long sadd(String key, String ... members) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.sadd(key, members);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long zadd(String key, double score, String member) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.zadd(key, score, member);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long zrem(String key, String member) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.zrem(key, new String[]{member});
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double zscore(String key, String member) {
        double ret = 0.0;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.zscore(key, member);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> zrange(String key, long start, long end) {
        Set ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.zrange(key, start, end);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long zcard(String key) {
        if (key == null) {
            return 0L;
        }
        long ret = 0L;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.zcard(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key) {
        String ret = null;
        try (ShardedJedis jedis = null;){
            jedis = pool.getResource();
            ret = jedis.get(key);
        }
        return ret;
    }

    static {
        poolConfig = new GenericObjectPoolConfig();
        log.info((Object)"JedisManager static code block loader...");
        poolConfig.setMaxTotal(500);
        poolConfig.setMaxIdle(60000);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setTestOnBorrow(true);
        String dbIndex = RedisConfig.getString("efuture.cache.redisDatabase");
        String[] strArray = RedisConfig.getRedisArray();
        log.info((Object)strArray[0]);
        String password = RedisConfig.getStringArray("efuture.cache.redisPassword")[0];
        log.info((Object)password);
        ArrayList<JedisShardInfo> shardJedis = new ArrayList<JedisShardInfo>();
        for (int i = 0; i < strArray.length; ++i) {
            int port = Integer.parseInt(strArray[i].split(":")[1]);
            String host = strArray[i].split(":")[0];
            if (dbIndex != null && dbIndex.matches("^\\d+$")) {
                String url = "http://" + host + ":" + port + "/" + dbIndex;
                try {
                    JedisShardInfo jedisShardInfo = new JedisShardInfo(new URI(url));
                    if (password != null && !password.equals("")) {
                        jedisShardInfo.setPassword(password);
                    }
                    shardJedis.add(jedisShardInfo);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                if (i != 0) continue;
                jedisPool = new JedisPool(poolConfig, host, port, 5000, password, Integer.parseInt(dbIndex));
                continue;
            }
            JedisShardInfo jedisShardInfo = new JedisShardInfo(host, port, 5000);
            if (password != null && !password.equals("")) {
                jedisShardInfo.setPassword(password);
            }
            shardJedis.add(jedisShardInfo);
            if (i != 0) continue;
            jedisPool = new JedisPool(poolConfig, host, port, 5000, password);
        }
        pool = new ShardedJedisPool(poolConfig, shardJedis);
    }
}

