/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.changedata;

import com.efuture.ocp.common.changedata.ChangeDataService;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="ocp.common.changedata")
public class ChangeDataServiceImpl
extends BasicComponent
implements ChangeDataService {
    public static ChangeDataServiceImpl createChangeDataServiceObject() {
        ChangeDataServiceImpl changedata = null;
        String objname = "ocp.common.changedata";
        changedata = SpringBeanFactory.containsBean(objname) ? SpringBeanFactory.getBean(objname, ChangeDataServiceImpl.class) : SpringBeanFactory.getBean(objname, ChangeDataServiceImpl.class);
        return changedata;
    }

    @Override
    public List<Map<String, Object>> getChangeDataConfig(long ent_id) {
        FMybatisTemplate storage = null;
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("status").is((Object)"Y");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((String[])new String[]{"ph_key"}));
        try {
            storage = (FMybatisTemplate)this.getStorageOperations();
            List list = storage.select(query, "changedataconfig");
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Map<String, Object> getChangeDataConfigByName(long ent_id, String objectname) {
        FMybatisTemplate storage = null;
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("objectname").is((Object)objectname).and("status").is((Object)"Y");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((String[])new String[]{"ph_key"}));
        query.limit(1);
        try {
            storage = (FMybatisTemplate)this.getStorageOperations();
            Map changedataconfig = storage.selectOne(query, "changedataconfig");
            return changedataconfig;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Map<String, Object> getChangeDataConfigById(long ent_id, String id) {
        FMybatisTemplate storage = null;
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("cid").is((Object)id).and("status").is((Object)"Y");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((String[])new String[]{"ph_key"}));
        query.limit(1);
        try {
            storage = (FMybatisTemplate)this.getStorageOperations();
            Map changedataconfig = storage.selectOne(query, "changedataconfig");
            return changedataconfig;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, Object> getChangeDataConfigByKey(long ent_id, String key, String keyValue) {
        Map<String, Object> changedataconfig = null;
        if (Utils.nvl(key, "").equals("id")) {
            changedataconfig = this.getChangeDataConfigById(ent_id, keyValue);
        } else if (Utils.nvl(key, "").equals("objectname")) {
            changedataconfig = this.getChangeDataConfigByName(ent_id, keyValue);
        }
        return changedataconfig;
    }

    @Override
    public String contrastBeanObj(AbstractEntityBean pojo1, AbstractEntityBean pojo2, long ent_id, String key, String keyValue) {
        StringBuilder str = new StringBuilder();
        int maxlength = 0;
        try {
            Class<?> clazz = pojo2.getClass();
            Field[] fields = clazz.getDeclaredFields();
            int i = 1;
            Map<String, Object> changedataconfig = this.getChangeDataConfigByKey(ent_id, key, keyValue);
            String ckeys = MapUtils.getString(changedataconfig, "ckeys", "", false);
            String ekeys = MapUtils.getString(changedataconfig, "ekeys", "", false);
            maxlength = MapUtils.getInteger(changedataconfig, "maxlength", 0);
            for (Field field : fields) {
                if ("serialVersionUID".equals(field.getName()) || (!StringUtils.isEmpty((Object)ckeys) ? ",".concat(ckeys).concat(",").indexOf(",".concat(field.getName()).concat(",")) < 0 : !StringUtils.isEmpty((Object)ekeys) && ",".concat(ekeys).concat(",").indexOf(",".concat(field.getName()).concat(",")) >= 0)) continue;
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                Method getMethod = pd.getReadMethod();
                Object o1 = getMethod.invoke((Object)pojo1, new Object[0]);
                Object o2 = getMethod.invoke((Object)pojo2, new Object[0]);
                if (o1 == null && o2 == null || Utils.nvl(o1, "").equals(Utils.nvl(o2, ""))) continue;
                str.append(i + ". " + field.getName() + ",\u539f\u503c:{" + Utils.nvl(o1, "") + "}, \u65b0\u503c:{" + Utils.nvl(o2, "") + "};  ");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxlength == 0 ? str.toString() : str.toString().substring(0, Math.min(maxlength, str.toString().length()));
    }

    @Override
    public String contrastMapObj(Map pojo1, Map pojo2, long ent_id, String key, String keyValue) {
        StringBuilder str = new StringBuilder();
        int maxlength = 0;
        try {
            int i = 1;
            Map<String, Object> changedataconfig = this.getChangeDataConfigByKey(ent_id, key, keyValue);
            if (changedataconfig == null) {
                return "";
            }
            String ckeys = MapUtils.getString(changedataconfig, "ckeys", "", false);
            String ekeys = MapUtils.getString(changedataconfig, "ekeys", "", false);
            maxlength = MapUtils.getInteger(changedataconfig, "maxlength", 0);
            for (Object fieldobj : pojo2.keySet()) {
                String field = (String)fieldobj;
                if ("serialVersionUID".equals(field) || (!StringUtils.isEmpty((Object)ckeys) ? ",".concat(ckeys).concat(",").indexOf(",".concat(field).concat(",")) < 0 : !StringUtils.isEmpty((Object)ekeys) && ",".concat(ekeys).concat(",").indexOf(",".concat(field).concat(",")) >= 0)) continue;
                String s1 = Utils.nvl(pojo1.get(field), "");
                String s2 = Utils.nvl(pojo2.get(field), "");
                if (s1.equals("") && s2.equals("") || s1.equals(s2)) continue;
                str.append(i + ". " + field + ",\u539f\u503c:{" + s1 + "}, \u65b0\u503c:{" + s2 + "};  ");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxlength == 0 ? str.toString() : str.toString().substring(0, maxlength);
    }
}

