/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.language;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.text.MessageFormat;
import java.util.Locale;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.StringUtils;

public class MessageSourceHelper {
    private AbstractResourceBasedMessageSource messageSource;
    private Locale defaultLocale = null;

    public static MessageSourceHelper getDefault() {
        return (MessageSourceHelper)SpringBeanFactory.getBean(EnvironmentParaUtils.getEnvPra("efuture.main.message", "messageSourceHelper"));
    }

    public static String getMessage(String code, String locale, Object ... args) {
        return MessageSourceHelper.getDefault().getMessage(code, code, StringUtils.isEmpty((Object)locale) ? null : new Locale(locale), args);
    }

    public static String formatMessage(String message, Object ... args) {
        String locale = ServiceRestReflect.getLocale().get().getLocale();
        return MessageSourceHelper.getDefault().getMessage("10000", message, StringUtils.isEmpty((Object)locale) ? null : new Locale(locale), args);
    }

    protected boolean isSpecCode(String code) {
        return "10000".equalsIgnoreCase(code) || "50000".equalsIgnoreCase(code);
    }

    public void setDefaultLocale(String locale) {
        locale = ServiceSession.compatibleLocale(locale);
        if (this.defaultLocale == null || !this.defaultLocale.getLanguage().equalsIgnoreCase(locale)) {
            this.defaultLocale = new Locale(locale);
        }
    }

    public String getMessage(String code, String defaultMessage, Locale locale, Object ... args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = String.valueOf(args[i]);
        }
        if (locale == null) {
            if (this.defaultLocale == null) {
                this.defaultLocale = new Locale(EnvironmentParaUtils.getEnvPra("efuture.main.message.lang", "cn"));
            }
            locale = this.defaultLocale;
        }
        String msg = null;
        if (locale == null || "cn".equalsIgnoreCase(locale.getLanguage()) || "zh".equalsIgnoreCase(locale.getLanguage())) {
            if (!this.isSpecCode(code)) {
                msg = this.messageSource.getMessage(code, args, defaultMessage, locale);
            }
            if (!StringUtils.isEmpty((Object)defaultMessage) && (StringUtils.isEmpty(msg) || this.isSpecCode(code))) {
                try {
                    if (args != null && args.length > 0) {
                        defaultMessage = MessageFormat.format(defaultMessage, args);
                    }
                    msg = defaultMessage;
                }
                catch (Exception ex) {
                    msg = defaultMessage;
                }
            }
        } else {
            if (!this.isSpecCode(code)) {
                msg = this.messageSource.getMessage(code, args, null, locale);
            }
            if (!StringUtils.isEmpty((Object)defaultMessage) && (StringUtils.isEmpty((Object)msg) || this.isSpecCode(code))) {
                if (EnvironmentParaUtils.getEnvPra("efuture.main.message.prior", Boolean.class, false).booleanValue()) {
                    String key = "language:" + locale.getLanguage() + ":" + MD5Utils.MD5(defaultMessage);
                    try {
                        msg = (String)CacheUtils.getCacheUtils().getData(key);
                        if (!StringUtils.isEmpty((Object)msg)) {
                            if (msg.startsWith("{")) {
                                msg = JSONObject.parseObject((String)msg).getString("value");
                            }
                            if (!StringUtils.isEmpty((Object)msg)) {
                                msg = MessageFormat.format(msg, args);
                            }
                        }
                    }
                    catch (Exception ex) {
                        msg = null;
                    }
                }
                if (StringUtils.isEmpty((Object)msg)) {
                    msg = this.messageSource.getMessage(defaultMessage, args, defaultMessage, locale);
                }
            }
        }
        return msg != null ? msg.trim() : msg;
    }

    public void setMessageSource(AbstractResourceBasedMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setMessageSource(ResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

