/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.log4j;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="efuture", category="Lookup")
public class EfutureLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Marker LOOKUP = MarkerManager.getMarker((String)"LOOKUP");
    private static Map<String, String> IPS = new HashMap<String, String>();
    private static String port = "";
    private static String ipAddr0 = "000";
    private static String ipAddr1 = "000";
    private static String ip = "";
    private static Map<String, String> efutureEnv = new HashMap<String, String>();
    private static final int INADDR4SZ = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookup(LogEvent event, String key) {
        try {
            if (key == null || "".equals(key)) {
                return "";
            }
            if (!efutureEnv.containsKey(key)) {
                Map<String, String> map = efutureEnv;
                synchronized (map) {
                    if (!efutureEnv.containsKey(key)) {
                        if (key.startsWith("appId")) {
                            EfutureLookup.getPort();
                            String skey = key.substring(5).trim();
                            String[] addr = EfutureLookup.getIpAddr(skey);
                            Object _appId = "";
                            _appId = "".equals(port) ? addr[1] + addr[2] : addr[2] + port;
                            LOGGER.warn("Efuture [{}] LogId [{}]", (Object)key, _appId);
                            efutureEnv.put(key, (String)_appId);
                        } else if (key.equals("MALL_APPID") || key.equals("EFUTURE_APPID")) {
                            EfutureLookup.getPort();
                            String val = System.getProperty(key);
                            if (val == null) {
                                val = System.getenv(key);
                            }
                            LOGGER.warn("env [{}] [{}]", (Object)key, (Object)val);
                            String prefix = null;
                            Object _appId = "";
                            if (val == null || "".equals(val)) {
                                prefix = System.getProperty(key + "_PREFIX");
                                if (prefix == null) {
                                    prefix = System.getenv(key + "_PREFIX");
                                }
                                LOGGER.warn("env [{}_PREFIX] [{}]", (Object)key, (Object)prefix);
                                String skey = prefix == null ? "" : prefix;
                                String[] addr = EfutureLookup.getIpAddr(skey);
                                _appId = "".equals(port) ? addr[1] + addr[2] : addr[2] + port;
                            } else {
                                _appId = val;
                            }
                            LOGGER.warn("Efuture [{}] LogId [{}]", (Object)key, _appId);
                            efutureEnv.put(key, (String)_appId);
                        } else {
                            try {
                                String val = System.getProperty(key);
                                if (val == null) {
                                    val = System.getenv(key);
                                }
                                efutureEnv.put(key, val);
                                LOGGER.warn("Efuture [{}] value [{}]", (Object)key, (Object)val);
                            }
                            catch (Exception ex) {
                                LOGGER.warn(LOOKUP, "Error while getting system property [{}].", (Object)key, (Object)ex);
                                return null;
                            }
                        }
                    }
                }
            }
            return efutureEnv.get(key);
        }
        catch (Exception ex) {
            LOGGER.warn(LOOKUP, "Error while getting property [{}].", (Throwable)ex);
            return null;
        }
    }

    private static void getPort() {
        String path = "";
        try {
            path = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6log4j\u8fd0\u884c\u8def\u5f84\u5931\u8d25[{}]", (Object)path, (Object)e);
            path = "";
        }
        LOGGER.warn("efuture path:[{}]", (Object)path);
        String regex = "\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String s = matcher.group();
            if (s.length() <= 3) continue;
            port = matcher.group();
        }
        port = port != null && port.length() > 3 ? port.substring(port.length() - 3) : "";
        LOGGER.warn("efuture port:[{}]", (Object)port);
    }

    private static String[] getIpAddr(String prefix) {
        try {
            InetAddress lo = InetAddress.getLocalHost();
            if (!lo.isAnyLocalAddress() && !lo.isLoopbackAddress() && lo instanceof Inet4Address) {
                String key = lo.getHostAddress();
                IPS.put(key, lo.getHostName());
                if (EfutureLookup.isIpv4(key) && key.startsWith(prefix)) {
                    ip = key;
                }
            }
        }
        catch (UnknownHostException e) {
            LOGGER.warn("\u8b66\u544a:getLocalHost\u7cfb\u7edf\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38", (Throwable)e);
        }
        if ("".equals(ip)) {
            try {
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                block4: for (NetworkInterface netint : Collections.list(nets)) {
                    if (netint.isLoopback() || !netint.isUp() || netint.isVirtual() || netint.isPointToPoint()) continue;
                    List<InterfaceAddress> netips = netint.getInterfaceAddresses();
                    for (InterfaceAddress addr : netips) {
                        InetAddress ia = addr.getAddress();
                        if (!(ia instanceof Inet4Address)) continue;
                        String key = ia.getHostAddress();
                        IPS.put(key, ia.getHostName());
                        if (!EfutureLookup.isIpv4(key) || !EfutureLookup.isInternalIp(key) || !key.startsWith(prefix)) continue;
                        ip = key;
                        continue block4;
                    }
                }
            }
            catch (SocketException e) {
                LOGGER.warn("\u8b66\u544a:\u7cfb\u7edf\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38", (Throwable)e);
            }
        }
        String[] rtn = null;
        String[] address = null;
        if ("".equals(ip)) {
            IPS.put("127.0.0.1", "localhost");
            IPS.put("0.0.0.0", "localhost");
            for (String key : IPS.keySet()) {
                if (!EfutureLookup.isIpv4(key) || !EfutureLookup.isInternalIp(key) || !key.startsWith(prefix)) continue;
                ip = key;
                break;
            }
            if ("".equals(ip) || "0.0.0.0".equals(ip)) {
                for (String key : IPS.keySet()) {
                    if (!EfutureLookup.isIpv4(key) || !key.startsWith(prefix)) continue;
                    ip = key;
                    break;
                }
            }
            if ("".equals(ip)) {
                ip = "127.0.0.1";
            }
        }
        address = ip.split("\\.");
        ipAddr0 = address[3];
        ipAddr1 = address[2];
        rtn = new String[]{ip, String.format("%03d", Integer.parseInt(ipAddr1)), String.format("%03d", Integer.parseInt(ipAddr0))};
        LOGGER.warn("efuture ip \u5730\u5740[{}], [{}], [{}]", (Object)rtn[0], (Object)rtn[1], (Object)rtn[2]);
        return rtn;
    }

    private static boolean isIpv4(String ip) {
        return ip.indexOf(46) != -1;
    }

    private static boolean isInternalIp(String ip) {
        byte[] addr = EfutureLookup.textToNumericFormatV4(ip);
        return EfutureLookup.isInternalIp(addr);
    }

    private static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public static void main(String[] args) {
        try {
            System.out.println("\u672c\u673aIPv4\u4e3a\uff1a" + InetAddress.getLocalHost().getHostAddress());
            EfutureLookup look = new EfutureLookup();
            System.out.println(look.lookup(null, "appId"));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

