/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.log4j;

import com.plumelog.core.MessageAppenderFactory;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.ThreadPoolUtil;
import com.plumelog.log4j2.util.LogMessageUtil;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class PlumeLogAppenderForLite
extends AbstractAppender {
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private final String appName;
    private final String env;
    private final String plumelogHost;
    private final String runModel;
    private final String expand;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 5;
    private boolean compressor = false;
    private String model = "standalone";

    protected PlumeLogAppenderForLite(String name, String appName, String env, String plumelogHost, String runModel, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String expand, int maxCount, int logQueueSize, int threadPoolSize, boolean compressor, String model, String masterName) {
        super(name, filter, layout, ignoreExceptions);
        this.appName = appName;
        this.env = env;
        this.plumelogHost = plumelogHost;
        this.runModel = runModel;
        this.expand = expand;
        this.maxCount = maxCount;
        this.logQueueSize = logQueueSize;
        this.threadPoolSize = threadPoolSize;
        this.compressor = compressor;
        this.model = model;
    }

    public static PlumeLogAppenderForLite createAppender(String name, String appName, String env, String plumelogHost, int maxCount, String runModel, String expand, int logQueueSize, int threadPoolSize, boolean compressor, String model, String masterName, Layout<? extends Serializable> layout, Filter filter) {
        if (env == null) {
            env = "default";
        }
        if (runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(runModel);
        }
        if (expand != null && LogMessageConstant.EXPANDS.contains(expand)) {
            LogMessageConstant.EXPAND = expand;
        }
        if (model == null) {
            model = "standalone";
        }
        if (maxCount == 0) {
            maxCount = 100;
        }
        if (logQueueSize == 0) {
            logQueueSize = 10000;
        }
        if (threadPoolSize == 0) {
            threadPoolSize = 1;
        }
        int count = maxCount;
        MessageAppenderFactory.initQueue((int)logQueueSize);
        for (int a = 0; a < threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((String)plumelogHost, (int)count, (String)(compressor ? "plume_log_list_compress" : "plume_log_list"), (boolean)compressor));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((String)plumelogHost, (int)count, (String)(compressor ? "plume_trace_list_compress" : "plume_trace_list"), (boolean)compressor));
        }
        return new PlumeLogAppenderForLite(name, appName, env, plumelogHost, runModel, filter, layout, true, expand, maxCount, logQueueSize, threadPoolSize, compressor, model, masterName);
    }

    public void append(LogEvent logEvent) {
        if (logEvent != null) {
            this.send(logEvent);
        }
    }

    protected void send(LogEvent logEvent) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage((String)this.appName, (String)this.env, (LogEvent)logEvent, (String)this.runModel);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage((RunLogMessage)((RunLogMessage)logMessage), (LogEvent)logEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModel() {
        return this.model;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public String getPlumelogHost() {
        return this.plumelogHost;
    }

    public String getExpand() {
        return this.expand;
    }

    public String getEnv() {
        return this.env;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }
}

