/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component(value="RestClientUtils_MyShop")
public class RestClientUtils_MyShop
extends RestClientUtils {
    public RestClientUtils_MyShop() {
    }

    public RestClientUtils_MyShop(int poolSize, long maxWait, String config) {
        super(poolSize, maxWait, config);
    }

    public RestClientUtils_MyShop(String config) {
        super(config);
    }

    private String getData(JSONObject json, String key, String defval) {
        if (json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return defval;
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, JSONObject param, String dataNode) throws Exception {
        String urlstr = this.getUrl(session, baseUrl, this.ent.getSrvConfig("authUrl", true), this.ent.getSrvConfig("authKey", true));
        String result = this.PostDataLog(urlstr, this.ent.getSrvConfig("authKey", true), param.toJSONString(), "UTF-8");
        this.logger.info((Object)("myshop.client.url: " + urlstr));
        this.logger.info((Object)("myshop.client.authKey: " + this.ent.getSrvConfig("authKey", true)));
        this.logger.info((Object)("myshop.client.param: " + param.toJSONString()));
        JSONObject ret = JSONObject.parseObject((String)result);
        String retcode = this.getData(ret, "code", "0");
        if (!"0".equals(retcode)) {
            return ServiceResponse.buildFailure(session, "10000", this.getData(ret, "msg", "N/A"), new Object[0]);
        }
        retcode = this.getData(ret, "returncode", "0");
        if (!"0".equals(retcode)) {
            return ServiceResponse.buildFailure(session, "10000", this.getData(ret, "data", "N/A"), new Object[0]);
        }
        if (!StringUtils.isEmpty((CharSequence)dataNode) && ret.containsKey((Object)dataNode)) {
            return ServiceResponse.buildSuccess(ret.get((Object)dataNode));
        }
        return ServiceResponse.buildSuccess(ret);
    }

    public String getTokenStr(long ent_id, String baseUrl, String authUrl, String authKey) throws Exception {
        String memKey = "MyShop" + String.valueOf(ent_id);
        String accessToken = null;
        JSONObject remote_token = new JSONObject();
        if (StringUtils.isEmpty(accessToken)) {
            remote_token = JSONObject.parseObject((String)this.getRemoteToken(authUrl, authKey));
            if (remote_token.containsKey((Object)"access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
            } else {
                throw new ServiceException("10000", "\u83b7\u53d6\u4ee3\u7406TOKEN\u9519\u8bef,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", new Object[0]);
            }
        }
        return "&access_token=".concat(accessToken);
    }

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)authUrl)) {
            String tokenStr = this.getTokenStr(session.getEnt_id(), baseUrl, authUrl, authKey);
            return baseUrl.concat(tokenStr);
        }
        return baseUrl;
    }

    protected String PostDataLog(String urlStr, String authKey, String content, String encoding) throws IOException {
        long logkey = UniqueID.getUniqueID();
        this.logger.info((Object)String.format("[%d] REQUEST: %s, %s", logkey, urlStr, content));
        String result = this.PostData(urlStr, authKey, content, encoding);
        this.logger.info((Object)String.format("[%d] RESPONSE: %s", logkey, result));
        return result;
    }

    protected String PostData(String urlStr, String authKey, String content, String encoding) throws IOException {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Authorization", authKey);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String getRemoteToken(String authUrl, String authKey) throws IOException {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(authUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Authorization", authKey);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

