/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Lazy(value=true)
@Component(value="RestClientUtils_dingding")
public class RestClientUtils_dingding
extends RestClientUtils {
    public RestClientUtils_dingding() {
    }

    public RestClientUtils_dingding(int poolSize, long maxWait, String config) {
        super(poolSize, maxWait, config);
    }

    public RestClientUtils_dingding(String config) {
        super(config);
    }

    private String getData(JSONObject json, String key, String defval) {
        if (json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return defval;
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        String urlstr = null;
        urlstr = !method.startsWith("http") ? this.queryServiceURI(method) : method;
        String result = this.PostDataLog(urlstr = Utils.getEnvValue(urlstr), param.toString(), "UTF-8", traceprex);
        JSONObject ret = JSONObject.parseObject((String)result);
        String return_code = this.getData(ret, "errcode", "-1");
        if ("0".equalsIgnoreCase(return_code)) {
            return ServiceResponse.buildSuccess(ret);
        }
        return ServiceResponse.buildFailure((ServiceSession)session, "10000", result, null);
    }

    protected String PostDataLog(String urlStr, String content, String encoding, String traceprex) throws IOException {
        if (!StringUtils.isEmpty((Object)traceprex)) {
            long logkey = UniqueID.getUniqueID();
            this.logger.info((Object)String.format("%s [%d] REQUEST: %s, %s", traceprex, logkey, urlStr, content));
            String result = RestClientUtils_dingding.PostData(urlStr, content, encoding);
            this.logger.info((Object)String.format("%s [%d] RESPONSE: %s", traceprex, logkey, result));
            return result;
        }
        return RestClientUtils_dingding.PostData(urlStr, content, encoding);
    }

    public static String PostData(String urlStr, String content, String encoding) throws IOException {
        URL realUrl = null;
        HttpURLConnection connection = null;
        try {
            realUrl = new URL(urlStr);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

