/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.RestClientUtils;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="RestClientUtils_IEGO")
public class RestClientUtils_iEGO
extends RestClientUtils {
    @Override
    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception {
        long entId = 0L;
        if (session != null && session instanceof ServiceSession) {
            entId = ((ServiceSession)session).getEnt_id();
        } else if (session != null && session instanceof Long) {
            entId = (Long)session;
        } else {
            throw new ServiceException("50000", "\u672a\u4f20\u5165\u4f01\u4e1a\u7f16\u53f7", new Object[0]);
        }
        String token = this.getEntToken(entId);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)token)) {
            throw new ServiceException("50000", "\u65e0\u6cd5\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1Token", new Object[0]);
        }
        String signStr = String.format("%s=%s", this.ent.getSrvConfig("app_key", true), this.ent.getSrvConfig("Secret", true)) + String.format("&body=%s", param.toString()) + String.format("&token=%s", token);
        String sign = MD5Utils.MD5(signStr);
        url = url.concat("&app_key=").concat(this.ent.getSrvConfig("app_key", true)).concat("&token=").concat(token).concat("&sign=").concat(sign);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        map.put("url", url);
        map.put("param", param);
        return map;
    }

    @AutoCache(Service="iEGO", KeyArgIndex=0)
    private String getEntToken(Long entId) throws Exception {
        Object data;
        ServiceSession session = new ServiceSession();
        session.setEnt_id(entId);
        String token_Url = this.ent.getSrvConfig("AuthUrl", true);
        JSONObject param = new JSONObject();
        param.put("code", (Object)this.ent.getSrvConfig("code", true));
        param.put("password", (Object)this.ent.getSrvConfig("password", true));
        Object result = RestClientUtils.getRestUtils().sendRequest(entId, token_Url, param, new RestClientUtils.requestCallback(){

            @Override
            public Object onSend(String url, Client client, Object param) {
                WebTarget taget = client.target(url);
                Invocation.Builder invocationBuilder = taget.request();
                return invocationBuilder.post(Entity.entity((Object)param, (MediaType)MediaType.APPLICATION_JSON_TYPE));
            }
        }, "notrace");
        JSONObject resobj = JSON.parseObject((String)((String)result));
        if (resobj.get((Object)"returncode").equals("0") && (data = resobj.get((Object)"data")) instanceof JSONObject && ((JSONObject)data).containsKey((Object)"token")) {
            return ((JSONObject)data).getString("token");
        }
        return null;
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
        return this.sendRequest(session, method, param, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        String url;
        ServiceSession ss = null;
        ss = session instanceof ServiceSession ? (ServiceSession)session : new ServiceSession();
        if (method.toLowerCase().startsWith("http")) {
            url = method;
        } else {
            url = this.queryServiceURI(ss.getEnt_id(), method);
            if (StringUtils.isEmpty((Object)url)) {
                throw new Exception("can't find method service url:" + method);
            }
        }
        Map<String, Object> map = this.doOverWrite(ss, method, url, param);
        method = map.get("method").toString();
        url = map.get("url").toString();
        param = map.get("param");
        Object result = RestClientUtils.getRestUtils().sendRequest(ss, url, param, new RestClientUtils.requestCallback(){

            @Override
            public Object onSend(String url, Client client, Object param) {
                WebTarget taget = client.target(url);
                Invocation.Builder invocationBuilder = taget.request();
                Response response = invocationBuilder.post(Entity.entity((Object)param, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                return response.readEntity(String.class);
            }
        }, "notrace");
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json;
            try {
                json = JSON.parseObject((String)((String)result));
            }
            catch (Exception ex) {
                json = new JSONObject();
                json.put("returncode", (Object)"50000");
                json.put("data", result);
            }
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
            if (response.getData() instanceof com.alibaba.fastjson2.JSONObject) {
                response.setData(json.getJSONObject("data"));
            } else if (response.getData() instanceof JSONArray) {
                response.setData(json.getJSONArray("data"));
            }
        }
        if (response == null) {
            throw new ServiceException("50000", (String)result, new Object[0]);
        }
        return response;
    }
}

