/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task;

import com.efuture.ocp.common.task.StepHandle;
import com.efuture.ocp.common.task.TaskContext;
import com.efuture.ocp.common.task.TaskResult;
import com.efuture.ocp.common.util.SpringBeanFactory;

public class StepContext {
    int step;
    int level;
    String stepCode;
    String stepDesc;
    String handleName;
    StepHandle handle;
    TaskContext taskCtx;

    public StepContext(int step, int level, String stepCode, String stepDesc, String handleName, TaskContext taskCtx) {
        this.step = step;
        this.level = level;
        this.stepCode = stepCode;
        this.stepDesc = stepDesc;
        this.handleName = handleName;
        this.taskCtx = taskCtx;
    }

    public StepContext(String stepCode, String handleName, TaskContext taskCtx) {
        this.stepCode = stepCode;
        this.handleName = handleName;
        this.taskCtx = taskCtx;
    }

    public StepContext(String stepCode, StepHandle handle, TaskContext taskCtx) {
        this.stepCode = stepCode;
        this.handle = handle;
        this.taskCtx = taskCtx;
        this.handleName = handle.getClass().getName();
    }

    public String getMsgKey() {
        return this.taskCtx.getTaskCode() + "-" + this.taskCtx.getTaskKey() + "-" + this.getStepCode();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getStepCode() {
        return this.stepCode;
    }

    public void setStepCode(String stepCode) {
        this.stepCode = stepCode;
    }

    public String getStepDesc() {
        return this.stepDesc;
    }

    public void setStepDesc(String stepDesc) {
        this.stepDesc = stepDesc;
    }

    public String getHandleName() {
        return this.handleName;
    }

    public void setHandleName(String handleName) {
        this.handleName = handleName;
    }

    public TaskContext getTaskCtx() {
        return this.taskCtx;
    }

    public void setTaskCtx(TaskContext taskCtx) {
        this.taskCtx = taskCtx;
    }

    public void setResult(TaskResult result) {
        this.taskCtx.setCurResult(result, this);
    }

    public TaskResult exec() {
        return this.getHandle().exec(this);
    }

    public StepHandle getHandle() {
        if (this.handle == null) {
            this.handle = SpringBeanFactory.getBean(this.handleName, StepHandle.class);
        }
        if (this.handle == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u6b65\u9aa4[" + this.stepCode + "]\u7684\u6267\u884c\u5668[" + this.handleName + "]");
        }
        return this.handle;
    }

    public boolean isSuccessStep() {
        return this.taskCtx.isSuccessStep(this.stepCode);
    }
}

