/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.task.CallBackHandle;
import com.efuture.ocp.common.task.StepContext;
import com.efuture.ocp.common.task.TaskContext;
import com.efuture.ocp.common.task.TaskEntity;
import com.efuture.ocp.common.task.TaskLog;
import com.efuture.ocp.common.task.TaskPublic;
import com.efuture.ocp.common.task.TaskRepository;
import com.efuture.ocp.common.task.TaskResult;
import com.efuture.ocp.common.task.impl.HttpCallBackHandle;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class TaskManager {
    ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 4, 5L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    TaskRepository taskRepo;
    private static TaskManager taskMgr;
    private HttpCallBackHandle defaultCallback = new HttpCallBackHandle();

    public static TaskManager getInstance() {
        if (taskMgr == null) {
            TaskManager.initInstance();
        }
        return taskMgr;
    }

    public static synchronized void initInstance() {
        if (taskMgr == null) {
            TaskRepository taskRepo = TaskPublic.getTaskRepo();
            taskMgr = new TaskManager(taskRepo);
        }
    }

    public TaskManager(TaskRepository taskRepo) {
        this.taskRepo = taskRepo;
    }

    public TaskEntity getLastTaskInfo(long entId, String taskCode) {
        return this.taskRepo.getLastTaskInfo(entId, taskCode);
    }

    public TaskEntity getTaskInfoByTaskKey(long entId, String taskKey) {
        return this.taskRepo.getTaskInfoByTaskKey(entId, taskKey);
    }

    public TaskContext create(long entId, String taskCode, String taskName, String taskType, String taskKey, String taskBizDate, Map<String, Object> param, Map<String, Object> config) {
        TaskContext ctx = this.create(entId, taskCode, taskName, taskType, taskKey, taskBizDate);
        ctx.setParam(param);
        ctx.setConfig(config);
        return ctx;
    }

    public TaskContext create(long entId, String taskCode, String taskName, String taskType, String taskKey, String taskBizDate) {
        TaskContext ctx = new TaskContext(entId, taskCode, taskName, taskType, taskKey, taskBizDate);
        return ctx;
    }

    public TaskResult exec(TaskContext taskCtx) {
        if (this.taskIsComplete(taskCtx)) {
            this.taskNotify(taskCtx);
            return TaskResult.success(taskCtx.getMsgKey(), "\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210", 0L);
        }
        taskCtx.initCurExec();
        this.lockOrSaveTask(taskCtx);
        this.doExecStep(taskCtx);
        this.saveTaskStatus(taskCtx);
        this.taskNotify(taskCtx);
        return taskCtx.getCurResult();
    }

    public void submit(TaskContext taskCtx) {
        this.executor.submit(() -> this.exec(taskCtx));
    }

    public TaskResult queryTaskResult(TaskContext taskCtx) {
        TaskEntity entity = this.taskRepo.getTaskInfoByTaskKey(taskCtx.getEntId(), taskCtx.getTaskKey());
        if (StringUtils.isEmpty((Object)entity)) {
            return null;
        }
        String msgKey = taskCtx.getMsgKey();
        long start = System.currentTimeMillis();
        TaskResult taskResult = TaskResult.success(msgKey, "\u5df2\u5b8c\u6210", start);
        taskResult.setResult(entity);
        return taskResult;
    }

    private void taskNotify(TaskContext taskCtx) {
        TaskEntity entity = taskCtx.toTaskEntity();
        Object callMsg = "no callback";
        long start = System.currentTimeMillis();
        try {
            CallBackHandle handle = taskCtx.getCallback();
            if (handle == null) {
                handle = this.defaultCallback;
            }
            callMsg = handle.onCallBack(taskCtx);
        }
        catch (Throwable th) {
            callMsg = "\u6267\u884c\u56de\u8c03\u9519\u8bef:" + th.getMessage();
        }
        ServiceLogs.debuglog("TaskManager.taskNotify", taskCtx.getMsgKey() + "-" + (String)callMsg, start);
        entity.setNotifyResult((String)callMsg);
        taskCtx.setCurExecEnd(new Date());
        TaskManager.getInstance().getTaskRepo().uptTaskNotifyResult(entity);
    }

    private void saveTaskStatus(TaskContext taskCtx) {
        if (taskCtx.getCurResult().isSuccess()) {
            taskCtx.setTaskStatus(100);
            taskCtx.setTaskMsg("\u6267\u884c\u6210\u529f");
        }
        taskCtx.setCurExecEnd(new Date());
        this.taskRepo.completeTask(taskCtx.toTaskEntity());
    }

    private void lockOrSaveTask(TaskContext taskCtx) {
        int timeOutMinute = 60;
        if (taskCtx.isSuccess()) {
            throw new RuntimeException(taskCtx.getMsgKey() + ":\u4efb\u52a1\u5df2\u7ecf\u6210\u529f\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\u9501\u5b9a");
        }
        taskCtx.setTaskRunCount(taskCtx.getTaskRunCount() + 1);
        if (taskCtx.getTaskStatus() == 0) {
            taskCtx.setTaskStatus(1);
            this.taskRepo.saveTask(taskCtx.toTaskEntity());
        } else if (taskCtx.getTaskStatus() == 10) {
            if (taskCtx.getLastExecStart() != null && DateUtil.between((Date)taskCtx.getLastExecStart(), (Date)taskCtx.getCurExecStart(), (DateUnit)DateUnit.MINUTE, (boolean)true) <= (long)timeOutMinute) {
                throw new RuntimeException(taskCtx.getMsgKey() + ":\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d");
            }
            taskCtx.setTaskStatus(10);
            this.taskRepo.startTask(taskCtx.toTaskEntity());
        } else {
            taskCtx.setTaskStatus(10);
            this.taskRepo.startTask(taskCtx.toTaskEntity());
        }
    }

    private void doExecStep(TaskContext taskCtx) {
        List<StepContext> stepContextList = taskCtx.getStepList();
        if (stepContextList == null || stepContextList.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u6267\u884c\u7684\u6b65\u9aa4");
        }
        boolean allSkip = false;
        for (StepContext step : stepContextList) {
            String msg = step.getMsgKey();
            if (step.isSuccessStep()) {
                allSkip = true;
                TaskLog.info(0L, msg + ":\u5df2\u7ecf\u6267\u884c\u6210\u529f,\u8df3\u8fc7\u6b64\u6b65\u9aa4", new Object[0]);
                continue;
            }
            allSkip = false;
            TaskLog.info(0L, msg + ":\u5f00\u59cb\u6267\u884c", new Object[0]);
            long start = System.currentTimeMillis();
            TaskResult result = this.doExecOneStep(step);
            if (!result.isSuccess()) {
                TaskLog.error(msg + ":\u6267\u884c\u53d1\u751f\u9519\u8bef " + result.getMsg(), new Object[0]);
                return;
            }
            TaskLog.info(start, msg + ":\u6267\u884c\u5b8c\u6210", new Object[0]);
        }
        if (allSkip) {
            taskCtx.setCurResult(TaskResult.success(taskCtx.getMsgKey(), "\u5168\u90e8\u90fd\u5df2\u7ecf\u6267\u884c\uff0c\u6267\u884c\u5b8c\u6210", 0L));
        }
    }

    private TaskResult doExecOneStep(StepContext step) {
        TaskResult result = null;
        String msgKey = step.getMsgKey();
        try {
            result = step.exec();
        }
        catch (Throwable throwable) {
            String msg = ExceptionUtil.getRootCauseMessage((Throwable)throwable) + "[" + ExceptionUtil.stacktraceToOneLineString((Throwable)throwable) + "]";
            result = TaskResult.error(msgKey, ":" + msg);
        }
        step.setResult(result);
        this.saveStepStatus(step);
        return result;
    }

    private void saveStepStatus(StepContext step) {
        this.taskRepo.uptTaskStepStatus(step.getTaskCtx().toTaskEntity());
    }

    private boolean taskIsComplete(TaskContext taskCtx) {
        TaskEntity entity = this.taskRepo.getTaskInfoByTaskKey(taskCtx.getEntId(), taskCtx.getTaskKey());
        if (entity != null) {
            taskCtx.syncFromEntity(entity);
        }
        return taskCtx.isComplete();
    }

    public TaskRepository getTaskRepo() {
        return this.taskRepo;
    }
}

