/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task.bill;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.task.StepHandle;
import com.efuture.ocp.common.task.TaskContext;
import com.efuture.ocp.common.task.TaskManager;
import com.efuture.ocp.common.task.TaskResult;
import com.efuture.ocp.common.task.bill.BillKeyParam;
import com.efuture.ocp.common.task.bill.NotifyParam;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class BillTaskBase
extends BasicComponent {
    public void entrance(ServiceSession session, JSONObject jsonparam) {
        BillKeyParam keyparam = BillKeyParam.getInstance(session, jsonparam);
        TaskContext ctx = TaskManager.getInstance().create(keyparam.ent_id, keyparam.billmoduleid, "", keyparam.billmoduleid, keyparam.getBillno(), DateUtil.formatDate((Date)new Date()));
        StepHandle sh = this.createStepHandle(keyparam);
        ctx.addStep(sh);
        NotifyParam notifyParam = this.setNotifyParam(jsonparam);
        if (notifyParam != null) {
            ctx.addParam("notifydata", notifyParam.getNotifydata());
            ctx.addParam("notifyurl", notifyParam.getNotifyurl());
        }
        TaskManager.getInstance().submit(ctx);
    }

    public String getnewmemo(String oldmemo, String msg, int maxlength) {
        int msgindex = oldmemo.indexOf("##");
        String newmemo = msgindex >= 0 ? (StringUtils.isEmpty((Object)msg) ? oldmemo.substring(0, msgindex) : oldmemo.substring(0, msgindex).concat("##").concat(msg)) : oldmemo.concat(StringUtils.isEmpty((Object)msg) ? "" : "##".concat(msg));
        newmemo = newmemo.substring(0, Math.min(maxlength, newmemo.length()));
        return newmemo;
    }

    public void taskExecAft(ServiceSession session, JSONObject jsonparam) throws Exception {
        String resultcode = DataUtils.getJsonData(jsonparam, "resultcode", true, null);
        JSONObject data = JSONObject.parseObject((String)DataUtils.getJsonData(jsonparam, "data", true, null));
        BillKeyParam keyparam = BillKeyParam.getInstance(session, data);
        TaskContext ctx = TaskManager.getInstance().create(keyparam.ent_id, keyparam.billmoduleid, "", keyparam.billmoduleid, keyparam.getBillno(), DateUtil.formatDate((Date)new Date()));
        TaskResult tr = TaskManager.getInstance().queryTaskResult(ctx);
        Object msg = "";
        if (tr != null && !StringUtils.isEmpty((Object)tr.getResult()) && tr.getResult().getTaskStatus() >= 100) {
            if (tr.getResult().getTaskStatus() != 100) {
                msg = "[" + keyparam.getBillno() + "] \u5355\u636e\u5ba1\u6838\u9519\u8bef! \r\n" + tr.getResult().getTaskMsg();
            }
        } else {
            msg = "[" + keyparam.getBillno() + "] \u5355\u636e\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!";
        }
        this.doTaskExecAft(session, keyparam, tr, (String)msg);
    }

    public void doTaskExecAft(ServiceSession session, BillKeyParam param, TaskResult tr, String msg) {
        FMybatisTemplate storage_work = SpringBeanFactory.getBean(param.getDbsource(), FMybatisTemplate.class);
        try {
            if (tr != null && tr.getResult().getTaskStatus() >= 100) {
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)param.getEnt_id()).and("billno").is((Object)param.getBillno());
                Query query = new Query((CriteriaDefinition)criteria);
                Map head = storage_work.selectOne(query, param.getHdtable());
                String memo = MapUtils.getString(head, param.getMemofiled(), "");
                ArrayList<String> statuslist = new ArrayList<String>();
                statuslist.add("W");
                statuslist.add("E");
                criteria.and("billstatus").in(statuslist);
                Update upt = new Update();
                upt.set("ph_timestamp", (Object)new Date());
                if (tr.getResult().getTaskStatus() > 100) {
                    upt.set("billstatus", (Object)"E");
                    if (!StringUtils.isEmpty((Object)param.memofiled)) {
                        String new_memo = this.getnewmemo(memo, msg, param.getMemomaxlength());
                        upt.set(param.getMemofiled(), (Object)new_memo);
                    }
                } else if (tr.getResult().getTaskStatus() == 100) {
                    upt.set("billstatus", (Object)"Y");
                    if (!StringUtils.isEmpty((Object)param.memofiled)) {
                        String new_memo = this.getnewmemo(memo, "", param.getMemomaxlength());
                        upt.set(param.getMemofiled(), (Object)new_memo);
                    }
                }
                query = new Query((CriteriaDefinition)criteria);
                storage_work.update(query, upt, param.getHdtable());
            }
        }
        catch (Exception ex) {
            throw new ServiceException("10000", ex.getMessage(), new Object[0]);
        }
        finally {
            if (storage_work != null) {
                storage_work.destroy();
            }
        }
    }

    public StepHandle createStepHandle(BillKeyParam keyparam) {
        return null;
    }

    public NotifyParam setNotifyParam(JSONObject jsonparam) {
        if (jsonparam.containsKey((Object)"notifyurl")) {
            NotifyParam notifyParam = new NotifyParam(jsonparam.toJSONString(), jsonparam.getString("notifyurl"));
            return notifyParam;
        }
        return null;
    }
}

