/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.CaseInsensitiveMap;
import com.efuture.omd.storage.mybatis.HashMapCase;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class BatisPluginLowerCase
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof DefaultResultSetHandler) {
            DefaultResultSetHandler resultSetHandler = (DefaultResultSetHandler)target;
            List results = resultSetHandler.handleResultSets((Statement)invocation.getArgs()[0]);
            if (results != null) {
                this.convert(results);
            }
            return results;
        }
        return invocation.proceed();
    }

    private void convert(List<Object> data) {
        for (int i = 0; i < data.size(); ++i) {
            Object m = data.get(i);
            if (m instanceof CaseInsensitiveMap || m instanceof HashMapCase) continue;
            if (m instanceof Map) {
                Map _m = (Map)m;
                CaseInsensitiveMap r = new CaseInsensitiveMap();
                for (Map.Entry e : _m.entrySet()) {
                    r.put(e.getKey().toString(), e.getValue());
                }
                data.set(i, r);
                continue;
            }
            if (!(m instanceof List)) continue;
            this.convert((List)m);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

