/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import com.efuture.ocp.common.util.RestClientUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.StringUtils;

public class RequestCopy {
    private static ThreadPoolExecutor executor;

    private static synchronized void initThreadPoolExecutor() {
        if (executor == null) {
            ThreadPoolExecutor threadPoolExecutor;
            int corePoolSize = 4;
            int maxPoolSize = 8;
            long keepAliveTime = TimeUnit.SECONDS.toNanos(60L);
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(50);
            NamedThreadFactory threadFactory = new NamedThreadFactory("RequestCopy-", false);
            ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
            executor = threadPoolExecutor = new ThreadPoolExecutor(4, 8, keepAliveTime, TimeUnit.NANOSECONDS, workQueue, threadFactory, handler);
        }
    }

    public static void copy(String method, ServiceSession session, String param) {
        try {
            String copyToSrv;
            ServiceSession serviceSession = session;
            if (serviceSession == null) {
                serviceSession = new ServiceSession();
            }
            if (StringUtils.isEmpty((Object)(copyToSrv = PropertiesCommon.CONFIG.REQ_COPY_TO_SERVICE.getVal(serviceSession.getEnt_id())))) {
                return;
            }
            if (executor == null) {
                RequestCopy.initThreadPoolExecutor();
            }
            RequestCopy.submit(method, session, copyToSrv, param);
        }
        catch (Throwable th) {
            ServiceLogs.debuglog("RequestCopy-submit-error", "\u63d0\u4ea4\u6d41\u91cf\u590d\u5236\u9519\u8bef:{0}", 0L, th.getMessage());
        }
    }

    private static void submit(String method, ServiceSession session, String copyToSrv, String param) {
        executor.submit(() -> {
            try {
                long entId = session.getEnt_id();
                String nginx = PropertiesCommon.CONFIG.NGINX_INSIDE.getVal(entId);
                String url = "http://" + nginx + "/" + copyToSrv + "/rest?method=" + method + "&ent_id=" + entId;
                RestClientUtils.getRestUtils().sendRequest(session, url, param);
            }
            catch (Throwable th) {
                ServiceLogs.debuglog("RequestCopy-error", "\u6d41\u91cf\u590d\u5236\u9519\u8bef:{0}", 0L, th.getMessage());
            }
        });
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final boolean daemon;

        public NamedThreadFactory(String namePrefix, boolean daemon) {
            this.namePrefix = namePrefix;
            this.daemon = daemon;
        }

        public NamedThreadFactory(String namePrefix) {
            this(namePrefix, false);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.namePrefix + " thread-" + threadNumber.getAndIncrement());
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

