/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.glassfish.jersey.client.ClientConfig;

public class RestClientFactory
extends BasePooledObjectFactory<Client> {
    private Map<String, Object> clientProperties = new HashMap<String, Object>();

    public RestClientFactory() {
    }

    public RestClientFactory(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public Client create() throws Exception {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.connectTimeout", (Object)10000);
        config.property("jersey.config.client.readTimeout", (Object)10000);
        if (this.clientProperties != null && !this.clientProperties.isEmpty()) {
            for (String key : this.clientProperties.keySet()) {
                if ("followRedirects".equalsIgnoreCase(key)) {
                    config.property("jersey.config.client.followRedirects", (Object)("true".equalsIgnoreCase(this.clientProperties.get(key).toString()) ? 1 : 0));
                    continue;
                }
                if ("readTimeout".equalsIgnoreCase(key)) {
                    config.property("jersey.config.client.readTimeout", (Object)Integer.parseInt(this.clientProperties.get(key).toString()));
                    continue;
                }
                if ("connectTimeout".equalsIgnoreCase(key)) {
                    config.property("jersey.config.client.connectTimeout", (Object)Integer.parseInt(this.clientProperties.get(key).toString()));
                    continue;
                }
                if (!"chunkedEncodingSize".equalsIgnoreCase(key)) continue;
                config.property("jersey.config.client.chunkedEncodingSize", (Object)Integer.parseInt(this.clientProperties.get(key).toString()));
            }
        }
        Client client = ClientBuilder.newClient((Configuration)config);
        return client;
    }

    public PooledObject<Client> wrap(Client paramT) {
        return new DefaultPooledObject((Object)paramT);
    }

    public void destroyObject(PooledObject<Client> p) throws Exception {
        ((Client)p.getObject()).close();
    }
}

