/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;

public class WebPathUtils {
    public static File getClassFile(Class<?> clazz) {
        URL path = clazz.getResource(clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1) + ".classs");
        if (path == null) {
            String name = clazz.getName().replaceAll("[.]", "/");
            path = clazz.getResource("/" + name + ".class");
        }
        return new File(path.getFile());
    }

    public static String getClassFilePath(Class<?> clazz) {
        try {
            return URLDecoder.decode(WebPathUtils.getClassFile(clazz).getAbsolutePath(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static File getClassPathFile(Class<?> clazz) {
        File file = WebPathUtils.getClassFile(clazz);
        int count = clazz.getName().split("[.]").length;
        for (int i = 0; i < count; ++i) {
            file = file.getParentFile();
        }
        if (file.getName().toUpperCase().endsWith(".JAR!")) {
            file = file.getParentFile();
        }
        return file;
    }

    public static String getClassPath(Class<?> clazz) {
        try {
            return URLDecoder.decode(WebPathUtils.getClassPathFile(clazz).getAbsolutePath(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getWebRootClassPath() {
        return WebPathUtils.getWebRootPath() + "/WEB-INF/classes";
    }

    public static String getWebRootPath() {
        Object result = WebPathUtils.class.getResource("WebPathUtils.class").toString();
        int index = ((String)result).indexOf("WEB-INF");
        if (index == -1) {
            index = ((String)result).indexOf("bin");
        }
        if (index == -1) {
            return System.getProperty("user.dir");
        }
        if (((String)(result = ((String)result).substring(0, index))).startsWith("jar")) {
            result = ((String)result).substring(10);
        } else if (((String)result).startsWith("wsjar:")) {
            result = ((String)result).substring(12);
        } else if (((String)result).startsWith("\\vfszip:\\")) {
            result = ((String)result).substring(9);
        } else if (((String)result).startsWith("file")) {
            result = ((String)result).substring(6);
        }
        if (((String)result).endsWith("/")) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        if (!((String)result).startsWith("/") && !((String)result).startsWith("\\")) {
            result = "/" + (String)result;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(WebPathUtils.getClassFilePath(WebPathUtils.class));
        System.out.println(WebPathUtils.getClassPath(WebPathUtils.class));
        System.out.println(WebPathUtils.getWebRootPath());
    }
}

