/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanFactory {
    static ApplicationContext context = null;
    static String[] ContextXml = null;

    SpringBeanFactory() {
    }

    public static void setContext(ApplicationContext ctx) {
        if (context == null) {
            context = ctx;
        }
    }

    public static Object getBean(String name) {
        return SpringBeanFactory.getContext().getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringBeanFactory.getContext().getBean(name, clazz);
    }

    public static boolean containsBean(String name) {
        return SpringBeanFactory.getContext().containsBean(name);
    }

    private static synchronized void getInstance() {
        if (context == null) {
            context = SpringBeanFactory.getWebApplicationContext();
        }
        if (context == null) {
            context = SpringBeanFactory.getApplicationContext();
        }
    }

    public static ApplicationContext getContext() {
        if (context != null) {
            return context;
        }
        return null;
    }

    private static void afterInitNotify(ApplicationContext cont) {
        System.out.println("start spring afterInitNotify.");
        try {
            ApplicationEvent event = (ApplicationEvent)cont.getBean("afterInitNotify");
            cont.publishEvent(event);
        }
        catch (Exception e) {
            System.out.println("bean [afterInitNotify] not found.");
        }
    }

    public static ApplicationContext getTemporaryContext(String contextFile) {
        ClassPathXmlApplicationContext cont = null;
        try {
            cont = new ClassPathXmlApplicationContext(contextFile);
        }
        finally {
            if (cont != null) {
                SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            }
        }
        return cont;
    }

    private static ApplicationContext getWebApplicationContext() {
        WebApplicationContext cont = null;
        try {
            cont = ContextLoader.getCurrentWebApplicationContext();
        }
        finally {
            if (cont != null) {
                SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            }
        }
        return cont;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ApplicationContext getApplicationContext() {
        ClassPathXmlApplicationContext cont = null;
        try {
            cont = ContextXml == null ? new ClassPathXmlApplicationContext(new String[]{"classpath*:**/applicationContext-*.xml", "classpath*:**/componentContext-*.xml"}) : new ClassPathXmlApplicationContext(ContextXml);
            if (cont == null) return cont;
        }
        catch (Throwable throwable) {
            if (cont == null) throw throwable;
            SpringBeanFactory.afterInitNotify(cont);
            throw throwable;
        }
        SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
        return cont;
    }

    public static void setApplicationContextXml(String[] contextFile) {
        ContextXml = contextFile;
    }

    public static void replaceNewSingletonBean(String name, Object newobj) {
        ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)SpringBeanFactory.getContext();
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)configurableContext.getBeanFactory();
        if (factory.containsSingleton(name)) {
            factory.destroySingleton(name);
        } else if (factory.containsBeanDefinition(name)) {
            factory.removeBeanDefinition(name);
        }
        factory.registerSingleton(name, newobj);
    }

    private static String getMethodName(String fildeName) throws Exception {
        byte[] items = fildeName.getBytes();
        items[0] = (byte)((char)items[0] - 97 + 65);
        return new String(items);
    }

    public static void setBeanFieldValue(Object inst, Field fld, final Object val) throws Exception {
        block31: {
            fld.setAccessible(true);
            if (fld.getType() == Integer.TYPE) {
                fld.setInt(inst, StringUtils.isEmpty((Object)val) ? 0 : Integer.parseInt(val.toString()));
            } else if (fld.getType() == Float.TYPE) {
                fld.setFloat(inst, StringUtils.isEmpty((Object)val) ? 0.0f : Float.parseFloat(val.toString()));
            } else if (fld.getType() == Double.TYPE) {
                fld.setDouble(inst, StringUtils.isEmpty((Object)val) ? 0.0 : Double.parseDouble(val.toString()));
            } else if (fld.getType() == Long.TYPE) {
                fld.setLong(inst, StringUtils.isEmpty((Object)val) ? 0L : Long.parseLong(val.toString()));
            } else if (fld.getType() == Short.TYPE) {
                fld.setShort(inst, StringUtils.isEmpty((Object)val) ? (short)0 : Short.parseShort(val.toString()));
            } else if (fld.getType() == Boolean.TYPE) {
                fld.setBoolean(inst, StringUtils.isEmpty((Object)val) ? false : Boolean.parseBoolean(val.toString()));
            } else if (fld.getType() == Character.TYPE) {
                fld.setChar(inst, StringUtils.isEmpty((Object)val) ? (char)' ' : val.toString().charAt(0));
            } else if (fld.getType() == Byte.TYPE) {
                fld.setByte(inst, StringUtils.isEmpty((Object)val) ? (byte)0 : val.toString().getBytes()[0]);
            } else if (fld.getType() == String.class) {
                fld.set(inst, StringUtils.isEmpty((Object)val) ? null : val.toString());
            } else if (fld.getType() == Map.class) {
                if (val instanceof String) {
                    try {
                        Method m = inst.getClass().getMethod("set" + SpringBeanFactory.getMethodName(fld.getName()), String.class);
                        if (m != null) {
                            m.invoke(inst, (String)val);
                        }
                        break block31;
                    }
                    catch (Exception ex) {
                        Method m = inst.getClass().getMethod("set" + SpringBeanFactory.getMethodName(fld.getName()), List.class);
                        if (m != null) {
                            m.invoke(inst, new ArrayList<String>(){
                                {
                                    this.add((String)val);
                                }
                            });
                        }
                        break block31;
                    }
                }
                fld.set(inst, val);
            } else if (fld.getType() == List.class) {
                if (val instanceof String) {
                    try {
                        Method m = inst.getClass().getMethod("set" + SpringBeanFactory.getMethodName(fld.getName()), String.class);
                        if (m != null) {
                            m.invoke(inst, (String)val);
                        }
                        break block31;
                    }
                    catch (Exception ex) {
                        Method m = inst.getClass().getMethod("set" + SpringBeanFactory.getMethodName(fld.getName()), List.class);
                        if (m != null) {
                            m.invoke(inst, new ArrayList<String>(){
                                {
                                    this.add((String)val);
                                }
                            });
                        }
                        break block31;
                    }
                }
                fld.set(inst, val);
            }
        }
    }
}

