/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.autorollback;

import com.efuture.ocp.common.autorollback.AutoRollBackService;
import com.efuture.ocp.common.autorollback.AutoRollbackAnnotation;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoRollbackAspect {
    private static final Logger logger = Logger.getLogger(AutoRollbackAspect.class);

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoRollbackAnnotation around) throws Throwable {
        Object result = null;
        String name = around.name();
        boolean ibhavetrans = false;
        Long transid = AutoRollBackService.gettransid();
        if (transid != null && transid != 0L) {
            ibhavetrans = true;
            logger.debug((Object)(name + ":\u5df2\u7ecf\u6709\u51b2\u6b63\u4e8b\u7269:" + transid));
        } else {
            transid = AutoRollBackService.opentrans();
            logger.debug((Object)(name + ":\u5f00\u542f\u51b2\u6b63\u4e8b\u7269:" + transid));
        }
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            logger.debug((Object)(name + ":\u6267\u884c\u51b2\u6b63:" + transid));
            AutoRollBackService.rollback();
            throw e;
        }
        finally {
            if (!ibhavetrans) {
                logger.debug((Object)(name + ":\u6267\u884c\u6e05\u7406:" + transid));
                AutoRollBackService.clean();
            } else {
                logger.debug((Object)(name + ":\u4e0d\u662f\u672c\u6b21\u4e8b\u7269,\u4e0d\u6267\u884c\u6e05\u7406:" + transid));
            }
        }
        return result;
    }
}

