/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.dict;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import com.efuture.ocp.common.dict.DictService;
import com.efuture.ocp.common.dict.MdmService;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.HashMap;
import java.util.Map;

public class MdmDictServiceImpl
implements DictService {
    private Cache<String, Map<String, Object>> dictCache = CacheUtil.newLRUCache((int)50000, (long)86400000L);
    private MdmService mdmService;

    @Override
    public String getDictName(long ent_id, String dictType, String jygs, String dictCode) {
        Map<String, Object> row = this.getDictData(ent_id, dictType, jygs, dictCode);
        if (row == null) {
            return dictCode;
        }
        if (row.isEmpty()) {
            ServiceLogs.debuglog("MdmDictServiceImpl.getDictName", "\u6ca1\u6709\u627e\u5230\u5b57\u5178\u6570\u636e[{0}]-[{1}]-[{2}]", 0L, dictType, jygs, dictCode);
            return dictCode;
        }
        return this.getMdmSrv().getMdmName(row, dictType);
    }

    public Map<String, Object> getDictData(long ent_id, String dicttype, String jygs, String dictcode) {
        String key = this.createCacheKey(ent_id, dicttype, jygs, dictcode);
        Map<String, Object> dict = this.getFromCache(key);
        if (dict == null) {
            dict = this.getRowData(ent_id, dicttype, jygs, dictcode);
            this.putCache(key, dict);
        }
        return dict;
    }

    private Map<String, Object> getRowData(long ent_id, String dicttype, String jygs, String dictcode) {
        return this.getMdmSrv().getMdmRowData(ent_id, dicttype, jygs, dictcode);
    }

    public String createCacheKey(long entId, String dictType, String jygs, String dictCode) {
        return entId + 45L + jygs + "-" + dictType + "-" + dictCode;
    }

    public void putCache(String key, Map<String, Object> value) {
        this.dictCache.put((Object)key, value);
    }

    public Map<String, Object> getFromCache(String key) {
        return (Map)this.dictCache.get((Object)key);
    }

    private String getLevelNameCol(String intype, int level) {
        return this.getLevelColBase(intype, level) + "_name";
    }

    private String getLevelColBase(String intype, int level) {
        String thiskeyStr = "efuture.report.mdm." + intype;
        String dbcol = EnvironmentParaUtils.getEnvPra(thiskeyStr + ".dbcol", intype);
        if (dbcol == null || dbcol.isEmpty()) {
            dbcol = intype;
        }
        return dbcol + "_L" + String.valueOf(level);
    }

    private String getLevelCodeCol(String intype, int level) {
        return this.getLevelColBase(intype, level) + "_code";
    }

    public Map<String, Object> genLevel(long ent_id, String jygs, Map<String, Object> rowdata, String inType, int level) {
        Map<String, Object> pmap = rowdata;
        int maxlevel = this.getMdmSrv().getMaxLevel(inType);
        do {
            String pkey = this.getLevelCodeCol(inType, level);
            String pkey_name = this.getLevelNameCol(inType, level);
            String pcode = null;
            if (pmap.get(this.getMdmSrv().getMdmPcodeCol(inType)) == null) continue;
            pcode = pmap.get(this.getMdmSrv().getMdmPcodeCol(inType)).toString();
            if ((pmap = this.getDictData(ent_id, inType, jygs, pcode)) == null) break;
            rowdata.put(pkey, pcode);
            rowdata.put(pkey_name, pmap.get("name"));
        } while (++level < maxlevel);
        return rowdata;
    }

    @Override
    public Map<String, Object> getLevelCodeName(long entId, String jygs, String inValue, String inType) {
        HashMap<String, Object> LevelCode = new HashMap<String, Object>();
        Map<String, Object> map = this.getDictData(entId, inType, jygs, inValue);
        if (map == null) {
            return LevelCode;
        }
        int level = 0;
        int maxLevel = this.getMdmSrv().getMaxLevel(inType);
        if (maxLevel == 0) {
            return map;
        }
        for (level = 0; level < maxLevel - 1; ++level) {
            String pkey = this.getLevelCodeCol(inType, level);
            String pkey_name = this.getLevelNameCol(inType, level);
            if (!map.containsKey(pkey) && map.get(this.getMdmSrv().getMdmPcodeCol(inType)) != null) {
                map = this.genLevel(entId, jygs, map, inType, 0);
            }
            if (!map.containsKey(pkey)) break;
            LevelCode.put(pkey, map.get(pkey).toString());
            LevelCode.put(pkey_name, map.get(pkey_name).toString());
        }
        return LevelCode;
    }

    public MdmService getMdmSrv() {
        if (this.mdmService == null) {
            String mdmServiceName = PropertiesCommon.CONFIG.MDM_DICT_DATA_LOAD.getVal(0L);
            this.mdmService = SpringBeanFactory.getBean(mdmServiceName, MdmService.class);
        }
        return this.mdmService;
    }

    public void setMdmService(MdmService mdmService) {
        this.mdmService = mdmService;
    }
}

