/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.fileio;

import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.fileio.DataImportConfigBean;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class DataImportConfigServiceImpl
extends BasicComponentService<DataImportConfigBean> {
    public DataImportConfigBean getConfig(long ent_id, String eid, String[] fields) {
        List rtn;
        Criteria cr = Criteria.where((String)"ent_id").is((Object)ent_id);
        cr.and("eid").regex("%" + eid + "%");
        Query query = new Query((CriteriaDefinition)cr);
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                query.fields().include(fields[i]);
            }
        }
        if ((rtn = this.getStorageOperations("GlobalStorageOperation").select(query, DataImportConfigBean.class)) != null && rtn.size() > 0) {
            if (rtn.size() > 1) {
                for (DataImportConfigBean ipconfig : rtn) {
                    if (!ipconfig.getEid().equals(this.getMultLanguageEid(eid))) continue;
                    return ipconfig;
                }
            }
            return (DataImportConfigBean)rtn.get(0);
        }
        return null;
    }

    private String getMultLanguageEid(String eid) {
        return eid.concat("_").concat(PropertiesCommon.CONFIG.LANG.getVal());
    }

    public List<DataImportConfigBean> getConfigByModule(long ent_id, String modulecode) {
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id);
        criteria.and("moduleid").regex("%" + modulecode + "%");
        Query query = new Query((CriteriaDefinition)criteria);
        List rtn = this.getStorageOperations("GlobalStorageOperation").select(query, DataImportConfigBean.class);
        ArrayList<DataImportConfigBean> rtnr = new ArrayList<DataImportConfigBean>();
        for (DataImportConfigBean ipconfig : rtn) {
            if (!ipconfig.getModuleid().equals(this.getMultLanguageEid(modulecode))) continue;
            rtnr.add(ipconfig);
        }
        if (rtnr.size() > 0) {
            return rtnr;
        }
        return rtn;
    }

    public List<Map<String, Object>> getOutConfigAll() {
        Criteria criteria = Criteria.where((String)"temptable").is((Object)"O").and("status").is((Object)"Y");
        Query query = new Query((CriteriaDefinition)criteria);
        return this.getStorageOperations().select(query, "dataimportconfig");
    }
}

