/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class UniqueClock {
    private final long period;
    private final AtomicLong now;

    private UniqueClock(long period) {
        this.period = period;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduleClockUpdating();
    }

    private static UniqueClock instance() {
        return InstanceHolder.INSTANCE;
    }

    public static long now() {
        return UniqueClock.instance().currentTimeMillis();
    }

    public static String nowDate() {
        return new Timestamp(UniqueClock.instance().currentTimeMillis()).toString();
    }

    private void scheduleClockUpdating() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "System Clock");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> this.now.set(System.currentTimeMillis()), this.period, this.period, TimeUnit.MILLISECONDS);
    }

    private long currentTimeMillis() {
        return this.now.get();
    }

    private static class InstanceHolder {
        public static final UniqueClock INSTANCE = new UniqueClock(1L);

        private InstanceHolder() {
        }
    }
}

