/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.storage.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelect;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.efuture.omd.storage.parser.ExprTranslator;
import com.efuture.omd.storage.parser.OracleSelectStatementWithLimit;
import com.efuture.omd.storage.parser.QueryExtractor;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;

public class QuerySelectExtractor
extends QueryExtractor {
    private Query query;
    private boolean needOrderBy = true;

    public QuerySelectExtractor(String collectionName, Query query) {
        this.collectionName = collectionName;
        this.query = query;
    }

    @Override
    public String getQueryForMongo() {
        StringBuilder sb = new StringBuilder();
        sb.append("db").append(".").append(this.collectionName).append(".find(").append(this.getMongoQueryString(this.query));
        if (this.query != null && this.query.getFieldsObject() != null) {
            sb.append(",").append(SerializationUtils.serializeToJsonSafely((Object)this.query.getFieldsObject()));
        }
        sb.append(")");
        if (this.query != null && this.query.getSortObject() != null) {
            sb.append(".sort(").append(SerializationUtils.serializeToJsonSafely((Object)this.query.getSortObject())).append(")");
        }
        if (this.query != null && this.query.getLimit() > 0) {
            sb.append(".limit(").append(this.query.getLimit()).append(")");
        }
        return sb.toString();
    }

    @Override
    public String getQueryForSQL() {
        OracleSelect select = null;
        switch (this.SQLDBType) {
            case ORACLE: {
                select = new OracleSelect();
                break;
            }
            case SQLSERVER: {
                select = new SQLServerSelect();
                break;
            }
            default: {
                select = new SQLSelect();
            }
        }
        select.setQuery(this.parseSelectQuery(this.collectionName, this.query));
        if (this.needOrderBy) {
            select.setOrderBy(this.parseOrderBy(this.query));
        }
        Object stmt = null;
        switch (this.SQLDBType) {
            case POSTGRESQL: {
                stmt = new PGSelectStatement((SQLSelect)select);
                break;
            }
            case ORACLE: {
                stmt = new OracleSelectStatementWithLimit((SQLSelect)select, this.query.getLimit());
                break;
            }
            default: {
                stmt = new SQLSelectStatement((SQLSelect)select);
            }
        }
        return this.getSQL((SQLStatement)stmt);
    }

    private SQLOrderBy parseOrderBy(Query query) {
        SQLOrderBy orderBy = new SQLOrderBy();
        if (query != null && query.getSortObject() != null) {
            DBObject sortObj = query.getSortObject();
            for (String key : sortObj.keySet()) {
                SQLSelectOrderByItem item = new SQLSelectOrderByItem();
                item.setExpr(ExprTranslator.translateKey(key));
                Integer value = (Integer)sortObj.get(key);
                if (value == 1) {
                    item.setType(SQLOrderingSpecification.ASC);
                } else if (value == -1) {
                    item.setType(SQLOrderingSpecification.DESC);
                }
                orderBy.addItem(item);
            }
        }
        return orderBy;
    }

    private SQLSelectQuery parseSelectQuery(String collectionName, Query query) {
        DB2SelectQueryBlock queryBlock = null;
        switch (this.SQLDBType) {
            case DB2: {
                queryBlock = new DB2SelectQueryBlock();
                break;
            }
            case MYSQL: {
                queryBlock = new MySqlSelectQueryBlock();
                break;
            }
            case ORACLE: {
                queryBlock = new OracleSelectQueryBlock();
                break;
            }
            case SQLSERVER: {
                queryBlock = new SQLServerSelectQueryBlock();
                break;
            }
            case POSTGRESQL: {
                queryBlock = new PGSelectQueryBlock();
                break;
            }
            default: {
                queryBlock = new SQLSelectQueryBlock();
            }
        }
        if (query != null && query.getLimit() > 0 && queryBlock instanceof MySqlSelectQueryBlock) {
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            limit.setRowCount((SQLExpr)new SQLNumberExpr((Number)query.getLimit()));
            limit.setOffset((SQLExpr)new SQLNumberExpr((Number)query.getSkip()));
            ((MySqlSelectQueryBlock)queryBlock).setLimit(limit);
            ((MySqlSelectQueryBlock)queryBlock).setOrderBy(this.parseOrderBy(query));
            this.needOrderBy = false;
        }
        queryBlock.setFrom((SQLTableSource)ExprTranslator.translateTableName(collectionName));
        this.parseSelectList(query, (SQLSelectQueryBlock)queryBlock);
        this.parseWhere(query, (SQLSelectQueryBlock)queryBlock);
        return queryBlock;
    }

    private void parseWhere(Query query, SQLSelectQueryBlock queryBlock) {
        if (query != null && query.getQueryObject() != null) {
            DBObject queryObj = query.getQueryObject();
            queryBlock.setWhere(ExprTranslator.translateWhere(queryObj, this.SQLDBType));
        }
    }

    private void parseSelectList(Query query, SQLSelectQueryBlock queryBlock) {
        List selectList = queryBlock.getSelectList();
        if (query != null && query.getFieldsObject() != null) {
            DBObject fieldObj = query.getFieldsObject();
            for (String key : fieldObj.keySet()) {
                Object value = fieldObj.get(key);
                if (!(value instanceof Integer) || (Integer)value != 1) continue;
                SQLSelectItem selectItem = new SQLSelectItem(ExprTranslator.translateKey(key), null);
                selectList.add(selectItem);
            }
        } else {
            SQLSelectItem selectItem = new SQLSelectItem((SQLExpr)new SQLAllColumnExpr(), null);
            selectList.add(selectItem);
        }
    }
}

