/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class ConfigHelper {
    private static Logger log = Logger.getLogger(ConfigHelper.class);

    public static URL locateConfig(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return ConfigHelper.findAsResource(path);
        }
    }

    public static URL findAsResource(String path) {
        URL url = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(path);
        }
        if (url != null) {
            return url;
        }
        url = ConfigHelper.class.getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(path);
        return url;
    }

    public static InputStream getConfigStream(String path) {
        URL url = ConfigHelper.locateConfig(path);
        if (url == null) {
            String msg = String.format("Unable to locate config file: %s", path);
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to open config file: %s", path), e);
        }
    }

    public static Reader getConfigStreamReader(String path) throws RuntimeException {
        return new InputStreamReader(ConfigHelper.getConfigStream(path));
    }

    public static Properties getConfigProperties(String path) throws RuntimeException {
        try {
            Properties properties = new Properties();
            properties.load(ConfigHelper.getConfigStream(path));
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties from specified config file: " + path, e);
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = ConfigHelper.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = ConfigHelper.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new RuntimeException(resource + " not found");
        }
        return stream;
    }

    public static InputStream getUserResourceAsStream(String resource) {
        boolean hasLeadingSlash = resource.startsWith("/");
        String stripped = hasLeadingSlash ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (stream = classLoader.getResourceAsStream(resource)) == null && hasLeadingSlash) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = ConfigHelper.class.getClassLoader().getResourceAsStream(resource);
        }
        if (stream == null && hasLeadingSlash) {
            stream = ConfigHelper.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new RuntimeException(resource + " not found");
        }
        return stream;
    }
}

