/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils;

import org.apache.log4j.Logger;

public class ConvertHelper {
    private static Logger logger = Logger.getLogger(ConvertHelper.class);

    public static String parseString(Object val) {
        return ConvertHelper.parseString(val, "");
    }

    public static String parseString(Object val, String defVal) {
        try {
            if (null == val) {
                return defVal;
            }
            return String.valueOf(val);
        }
        catch (Exception e) {
            logger.info((Object)"parseString Exception", (Throwable)e);
        }
        catch (Throwable e) {
            logger.info((Object)"parseString Exception", e);
        }
        return defVal;
    }

    public static long parseLong(String val) {
        return ConvertHelper.parseLong(val, 0L);
    }

    public static long parseLong(String val, long defaultVal) {
        try {
            if (null == val || val.isEmpty()) {
                return defaultVal;
            }
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            logger.info((Object)"parseLong NumberFormatException", (Throwable)e);
        }
        catch (Exception e) {
            logger.info((Object)"parseLong Exception", (Throwable)e);
        }
        return defaultVal;
    }

    public static int parseInt(String val) {
        return ConvertHelper.parseInt(val, 0);
    }

    public static int parseInt(String val, int defaultVal) {
        try {
            if (null == val || val.isEmpty()) {
                return defaultVal;
            }
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            logger.info((Object)"parseInt NumberFormatException", (Throwable)e);
        }
        catch (Exception e) {
            logger.info((Object)"parseInt Exception", (Throwable)e);
        }
        return defaultVal;
    }

    public static boolean parseBoolean(String val) {
        try {
            if (null == val || val.isEmpty()) {
                return false;
            }
            if ((val = val.toLowerCase()).startsWith("1") || val.startsWith("t")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info((Object)"parseBoolean Exception", (Throwable)e);
        }
        return false;
    }

    public static int parseInt(Object val) {
        return ConvertHelper.parseInt(ConvertHelper.parseString(val));
    }

    public static long parseLong(Object val) {
        return ConvertHelper.parseLong(ConvertHelper.parseString(val));
    }

    public static double parseDouble(String val, long defaultVal) {
        try {
            if (null == val || val.isEmpty()) {
                return defaultVal;
            }
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            logger.info((Object)"parseDouble NumberFormatException", (Throwable)e);
        }
        catch (Exception e) {
            logger.info((Object)"parseDouble Exception", (Throwable)e);
        }
        return defaultVal;
    }

    public static double parseDouble(String val) {
        return ConvertHelper.parseDouble(val, 0L);
    }

    public static double parseDouble(Object val) {
        return ConvertHelper.parseDouble(ConvertHelper.parseString(val));
    }
}

